//
//  QGHUDManager.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/8.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGHUDManager.h"
#import "MBProgressHUD.h"
#import "QGBasicUITool.h"
#import "QGLoadingView.h"
@interface QGHUDManager ()

/**
 正在加载中的HUD，加载中的HUD具有唯一性。
 */
@property (nonatomic, strong) MBProgressHUD * loadingHUD;
@end

@implementation QGHUDManager

///获取单例类，唯一官方指定获取该的对象方法
+(instancetype)shareManager
{
    static QGHUDManager * shareManager;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        shareManager = [[QGHUDManager alloc] init];
    });
    return shareManager;
}


/**
 *  加载动画（传入str 则变成提示，2S后自动消失）
 */
+(void)showHud:(NSString * __nullable)str;
{
    [self hideHudAnimated:NO];
    //显示文案提示，既定秒数后消失
    if (str.length > 0) {
        [self showHud:str afterDelay:2];
    }
    //显示加载中样式
    else
    {
        [self showLoadingHUD];
    }
}

/**
 显示加载中动画
 */
+ (void)showLoadingHUD
{
    MBProgressHUD * hud = [MBProgressHUD showHUDAddedTo:[self getKeyWindow] animated:NO];
    hud.mode = MBProgressHUDModeCustomView;
    QGLoadingView * loadingView = [[QGLoadingView alloc] init];
    hud.customView = loadingView;
    hud.userInteractionEnabled = YES;
    //边界
    hud.margin = 10;
    //弹窗的背景色
    hud.bezelView.backgroundColor = [UIColor clearColor];
    //记录加载中的HUD
    [QGHUDManager shareManager].loadingHUD = hud;
}

/**
 *  弹窗 N秒之后自动消失
 *
 *  @param str   弹窗文案
 *  @param delay 延时时间
 */
+(void)showHud:(NSString *)str afterDelay:(NSTimeInterval)delay
{
    [self hideHudAnimated:NO];
    MBProgressHUD * hud = [MBProgressHUD showHUDAddedTo:[self getKeyWindow] animated:NO];
    hud.mode = MBProgressHUDModeText;
    hud.label.text = str ? str : @"";
    hud.label.textColor = [UIColor whiteColor];
    hud.label.font = [UIFont qg_regularFontOfSize:14];
    hud.removeFromSuperViewOnHide = YES;
    hud.userInteractionEnabled = NO;
    CGFloat keyboardHeight = [self visibleKeyboardHeight];
    //偏移
    hud.offset = CGPointMake(0.f, keyboardHeight ?  -100: 100);
    //边界
    hud.margin = 10;
    //弹窗的背景色
    hud.bezelView.backgroundColor = [UIColor colorWithHexString:@"000000" alpha:.4];
    [hud hideAnimated:YES afterDelay:delay];
}

/**
 根据错误信息做出提示
 
 @param responseObject 包含message层级的字典
 */
+(void)showHudWithError:(NSDictionary *)responseObject
{
    [self hideHudAnimated:NO];
    if ([responseObject isKindOfClass:[NSDictionary class]]) {
        //获取到message
        NSString * messageStr = responseObject[@"msg"] ? responseObject[@"msg"] : responseObject[@"message"];
        if ([messageStr isKindOfClass:[NSString class]] && messageStr.length > 0) {
            [self showHud:messageStr afterDelay:2];
        }
    }
}

/**
 隐藏hud

 @param animated 是否需要动画
 */
+(void)hideHudAnimated:(BOOL)animated
{
    if ([QGHUDManager shareManager].loadingHUD) {
        [[QGHUDManager shareManager].loadingHUD hideAnimated:animated];
        [QGHUDManager shareManager].loadingHUD = nil;
    }
}

/**
 隐藏HUD带动画
 */
+(void)hideHud
{
    [self hideHudAnimated:YES];
}

///获取当前主Window
+ (UIWindow *)getKeyWindow
{
    NSEnumerator *frontToBackWindows = [UIApplication.sharedApplication.windows reverseObjectEnumerator];
    UIWindow * keyWindow = nil;
    for (UIWindow *window in frontToBackWindows){
        BOOL windowOnMainScreen = window.screen == UIScreen.mainScreen;
        BOOL windowIsVisible = !window.hidden && window.alpha > 0;
        BOOL windowLevelNormal = window.windowLevel == UIWindowLevelNormal;
        
        if (windowOnMainScreen && windowIsVisible && windowLevelNormal) {
            keyWindow = window;
            break;
        }
    }
    return keyWindow;
}


+ (CGFloat)visibleKeyboardHeight {
#if !defined(SV_APP_EXTENSIONS)
    UIWindow *keyboardWindow = nil;
    for (UIWindow *testWindow in [[UIApplication sharedApplication] windows]) {
        if(![[testWindow class] isEqual:[UIWindow class]]) {
            keyboardWindow = testWindow;
            break;
        }
    }
    
    for (__strong UIView *possibleKeyboard in [keyboardWindow subviews]) {
        if ([possibleKeyboard isKindOfClass:NSClassFromString(@"UIPeripheralHostView")] || [possibleKeyboard isKindOfClass:NSClassFromString(@"UIKeyboard")]) {
            return CGRectGetHeight(possibleKeyboard.bounds);
        } else if ([possibleKeyboard isKindOfClass:NSClassFromString(@"UIInputSetContainerView")]) {
            for (__strong UIView *possibleKeyboardSubview in [possibleKeyboard subviews]) {
                if ([possibleKeyboardSubview isKindOfClass:NSClassFromString(@"UIInputSetHostView")]) {
                    return CGRectGetHeight(possibleKeyboardSubview.bounds);
                }
            }
        }
    }
#endif
    return 0;
}


@end
