//
//  QGFaceVerifyManager.h
//  CreditWallet
//
//  Created by silicn on 2019/12/20.
//  Copyright © 2019 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>

/// OCR
#import <WBOCRService/WBOCRService.h>
/// Api
#import "QGFaceVerifyRequestApi.h"

typedef NS_ENUM(NSInteger,QGOCRIDCardType)
{
    QGOCRIDCardTypeFrontSide,  /// 人像面
    QGOCRIDCardTypeBackSide    /// 国徽面
};

NS_ASSUME_NONNULL_BEGIN

typedef void(^QGFaceVerifyResultBlock)(BOOL isSuccess, NSString *orderNo, NSInteger code);

@interface QGFaceVerifyManager : NSObject


/// 单例
+ (instancetype)shareInstance;

/// 拉起腾讯活体识别,并上报结果给Server,完成回调
/// @param completeBlock 上报结果完成
- (void)openFaceVerifySuccess:(void(^)(void))completeBlock;



/// 拉起腾讯OCR服务
/// @param type 人像面或者国徽面
/// @param ocrAuthToken ocr授权Token 服务器后台自定义Token,和SDK没毛关系
/// @param successBlock 识别成功
/// @param failureBlock 识别失败
- (void)startOCRServiceWithType:(QGOCRIDCardType)type
                  ocrAuthToken:(nullable NSString *)ocrAuthToken
                        success:(void(^)(WBIDCardInfoModel *model))successBlock
                        failure:(void(^)(NSError *error,NSString *orderNo))failureBlock;



/// 拉起腾讯活体识别获取识别结果-结果不上报后台
/// @param startSuccess SDK启动成功
/// @param startFailure SDK启动失败
/// @param result QGFaceVerifyResultBlock 活体识别结果
- (void)startFaceVerifyWithStartUpSuccess:(void(^)(void))startSuccess
                     startUpFailure:(void(^)(void))startFailure
                             result:(QGFaceVerifyResultBlock)result;




@end

NS_ASSUME_NONNULL_END
