//
//  QGDeviceTool.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGDeviceTool.h"
#import <AVFoundation/AVFoundation.h>
#import <AdSupport/AdSupport.h>
#import <mach/mach.h>
#include <mach/machine.h>
#include <sys/mount.h>
#include <sys/param.h>
#include <sys/sysctl.h>
#import <sys/utsname.h>
//获取IP
#include <ifaddrs.h>
#import <net/if.h>
#include <arpa/inet.h>

#import "QGDeviceId.h"
#import "QGAppMacro.h"
#import "QGToolsConfig.h"
@implementation QGDeviceTool

/*!
 唯一标示符
 注意：如果程序被删除了，然后在安装，这个数值会改变。
 如果想要永久保证这个数字不变，需要使用Keychain来保存这个字符串
 */
+ (NSString *)QGUUID
{
    NSString *uuid = [[[ASIdentifierManager sharedManager] advertisingIdentifier] UUIDString];
    return uuid;
}

/**
 随机生成32 为长度的UUID
 */
+ (NSString *)create32UUIDString {
    CFUUIDRef uuid_ref = CFUUIDCreate(NULL);
    CFStringRef uuid_string_ref = CFUUIDCreateString(NULL, uuid_ref);
    NSString *uuid = [NSString stringWithString:(__bridge NSString *) uuid_string_ref];
    CFRelease(uuid_ref);
    CFRelease(uuid_string_ref);
    NSString *uuidStr = [uuid lowercaseString];
    uuidStr = [uuidStr substringToIndex:32]; //截取掉下标16之前的字符串
    return uuidStr;
}

/*
 系统版本
 */
+ (CGFloat)systemVersion
{
    CGFloat version;
    UIDevice *currentDevice = [UIDevice currentDevice];
    version = currentDevice.systemVersion.floatValue;
    return version;
}

/**
 获取手机类型 mobileType
 @return iPhone 6s Plus
 */
+ (NSString *)getDeviceType
{
    struct utsname systemInfo;
    uname(&systemInfo);
    NSString *deviceString = [NSString stringWithCString:systemInfo.machine encoding:NSUTF8StringEncoding];
//    NSLog(@"platform = %@", deviceString);
    
    if ([deviceString isEqualToString:@"iPhone3,1"]) return @"iPhone 4";
    if ([deviceString isEqualToString:@"iPhone3,2"]) return @"iPhone 4";
    if ([deviceString isEqualToString:@"iPhone3,3"]) return @"iPhone 4";
    if ([deviceString isEqualToString:@"iPhone4,1"]) return @"iPhone 4S";
    if ([deviceString isEqualToString:@"iPhone5,1"]) return @"iPhone 5";
    if ([deviceString isEqualToString:@"iPhone5,2"]) return @"iPhone 5 (GSM+CDMA)";
    if ([deviceString isEqualToString:@"iPhone5,3"]) return @"iPhone 5c (GSM)";
    if ([deviceString isEqualToString:@"iPhone5,4"]) return @"iPhone 5c (GSM+CDMA)";
    if ([deviceString isEqualToString:@"iPhone6,1"]) return @"iPhone 5s (GSM)";
    if ([deviceString isEqualToString:@"iPhone6,2"]) return @"iPhone 5s (GSM+CDMA)";
    if ([deviceString isEqualToString:@"iPhone7,1"]) return @"iPhone 6 Plus";
    if ([deviceString isEqualToString:@"iPhone7,2"]) return @"iPhone 6";
    if ([deviceString isEqualToString:@"iPhone8,1"]) return @"iPhone 6s";
    if ([deviceString isEqualToString:@"iPhone8,2"]) return @"iPhone 6s Plus";
    if ([deviceString isEqualToString:@"iPhone8,4"]) return @"iPhone SE";
    // 日行两款手机型号均为日本独占，可能使用索尼FeliCa支付方案而不是苹果支付
    if ([deviceString isEqualToString:@"iPhone9,1"]) return @"国行、日版、港行iPhone 7";
    if ([deviceString isEqualToString:@"iPhone9,2"]) return @"港行、国行iPhone 7 Plus";
    if ([deviceString isEqualToString:@"iPhone9,3"]) return @"美版、台版iPhone 7";
    if ([deviceString isEqualToString:@"iPhone9,4"]) return @"美版、台版iPhone 7 Plus";
    if ([deviceString isEqualToString:@"iPhone10,1"]) return @"国行(A1863)、日行(A1906)iPhone 8";
    if ([deviceString isEqualToString:@"iPhone10,4"]) return @"美版(Global/A1905)iPhone 8";
    if ([deviceString isEqualToString:@"iPhone10,2"]) return @"国行(A1864)、日行(A1898)iPhone 8 Plus";
    if ([deviceString isEqualToString:@"iPhone10,5"]) return @"美版(Global/A1897)iPhone 8 Plus";
    if ([deviceString isEqualToString:@"iPhone10,3"]) return @"国行(A1865)、日行(A1902)iPhone X";
    if ([deviceString isEqualToString:@"iPhone10,6"]) return @"美版(Global/A1901)iPhone X";
    
    if ([deviceString isEqualToString:@"iPod1,1"]) return @"iPod Touch 1G";
    if ([deviceString isEqualToString:@"iPod2,1"]) return @"iPod Touch 2G";
    if ([deviceString isEqualToString:@"iPod3,1"]) return @"iPod Touch 3G";
    if ([deviceString isEqualToString:@"iPod4,1"]) return @"iPod Touch 4G";
    if ([deviceString isEqualToString:@"iPod5,1"]) return @"iPod Touch (5 Gen)";
    
    if ([deviceString isEqualToString:@"iPad1,1"]) return @"iPad";
    if ([deviceString isEqualToString:@"iPad1,2"]) return @"iPad 3G";
    if ([deviceString isEqualToString:@"iPad2,1"]) return @"iPad 2 (WiFi)";
    if ([deviceString isEqualToString:@"iPad2,2"]) return @"iPad 2";
    if ([deviceString isEqualToString:@"iPad2,3"]) return @"iPad 2 (CDMA)";
    if ([deviceString isEqualToString:@"iPad2,4"]) return @"iPad 2";
    if ([deviceString isEqualToString:@"iPad2,5"]) return @"iPad Mini (WiFi)";
    if ([deviceString isEqualToString:@"iPad2,6"]) return @"iPad Mini";
    if ([deviceString isEqualToString:@"iPad2,7"]) return @"iPad Mini (GSM+CDMA)";
    if ([deviceString isEqualToString:@"iPad3,1"]) return @"iPad 3 (WiFi)";
    if ([deviceString isEqualToString:@"iPad3,2"]) return @"iPad 3 (GSM+CDMA)";
    if ([deviceString isEqualToString:@"iPad3,3"]) return @"iPad 3";
    if ([deviceString isEqualToString:@"iPad3,4"]) return @"iPad 4 (WiFi)";
    if ([deviceString isEqualToString:@"iPad3,5"]) return @"iPad 4";
    if ([deviceString isEqualToString:@"iPad3,6"]) return @"iPad 4 (GSM+CDMA)";
    if ([deviceString isEqualToString:@"iPad4,1"]) return @"iPad Air (WiFi)";
    if ([deviceString isEqualToString:@"iPad4,2"]) return @"iPad Air (Cellular)";
    if ([deviceString isEqualToString:@"iPad4,4"]) return @"iPad Mini 2 (WiFi)";
    if ([deviceString isEqualToString:@"iPad4,5"]) return @"iPad Mini 2 (Cellular)";
    if ([deviceString isEqualToString:@"iPad4,6"]) return @"iPad Mini 2";
    if ([deviceString isEqualToString:@"iPad4,7"]) return @"iPad Mini 3";
    if ([deviceString isEqualToString:@"iPad4,8"]) return @"iPad Mini 3";
    if ([deviceString isEqualToString:@"iPad4,9"]) return @"iPad Mini 3";
    if ([deviceString isEqualToString:@"iPad5,1"]) return @"iPad Mini 4 (WiFi)";
    if ([deviceString isEqualToString:@"iPad5,2"]) return @"iPad Mini 4 (LTE)";
    if ([deviceString isEqualToString:@"iPad5,3"]) return @"iPad Air 2";
    if ([deviceString isEqualToString:@"iPad5,4"]) return @"iPad Air 2";
    if ([deviceString isEqualToString:@"iPad6,3"]) return @"iPad Pro 9.7";
    if ([deviceString isEqualToString:@"iPad6,4"]) return @"iPad Pro 9.7";
    if ([deviceString isEqualToString:@"iPad6,7"]) return @"iPad Pro 12.9";
    if ([deviceString isEqualToString:@"iPad6,8"]) return @"iPad Pro 12.9";
    if ([deviceString isEqualToString:@"iPad6,11"]) return @"iPad 5 (WiFi)";
    if ([deviceString isEqualToString:@"iPad6,12"]) return @"iPad 5 (Cellular)";
    if ([deviceString isEqualToString:@"iPad7,1"]) return @"iPad Pro 12.9 inch 2nd gen (WiFi)";
    if ([deviceString isEqualToString:@"iPad7,2"]) return @"iPad Pro 12.9 inch 2nd gen (Cellular)";
    if ([deviceString isEqualToString:@"iPad7,3"]) return @"iPad Pro 10.5 inch (WiFi)";
    if ([deviceString isEqualToString:@"iPad7,4"]) return @"iPad Pro 10.5 inch (Cellular)";
    
    if ([deviceString isEqualToString:@"AppleTV2,1"]) return @"Apple TV 2";
    if ([deviceString isEqualToString:@"AppleTV3,1"]) return @"Apple TV 3";
    if ([deviceString isEqualToString:@"AppleTV3,2"]) return @"Apple TV 3";
    if ([deviceString isEqualToString:@"AppleTV5,3"]) return @"Apple TV 4";
    
    if ([deviceString isEqualToString:@"i386"]) return @"Simulator";
    if ([deviceString isEqualToString:@"x86_64"]) return @"Simulator";
    if (deviceString.length == 0) {
        deviceString = @"未知";
    }
    return deviceString;
}

/**
 获取手机类型 DevicePlatform
 @return iPhone7,2
 */
+ (NSString *)getDevicePlatformType;
{
    struct utsname systemInfo;
    uname(&systemInfo);
    NSString *deviceString = [NSString stringWithCString:systemInfo.machine encoding:NSUTF8StringEncoding];
    return deviceString;
}

/**
 获取手机系统+版本号  iPhone10.2.1
 @return iPhone10.2.1
 */
+ (NSString *)getMobileModel
{
    NSString *systemVersion = [UIDevice currentDevice].systemVersion; //获取当前系统的版本
    NSString *strModel = [UIDevice currentDevice].model;
    NSString *mobileModel = [NSString stringWithFormat:@"%@%@", strModel, systemVersion];
    return mobileModel;
}

/**
 获取iPhone名称
 */
+ (NSString *)getiPhoneName;
{
    return [UIDevice currentDevice].name;
}

/**
 获取手机屏幕大小
 */
+ (NSString *)getScreenSize;
{
    CGRect rect = [[UIScreen mainScreen] bounds];
    CGSize size = rect.size;
    CGFloat width = size.width;
    CGFloat height = size.height;
    NSString *ScreenSizeStr = [NSString stringWithFormat:@"%0.2f%0.2f", height, width];
    return ScreenSizeStr;
}

/**
 获取CPU类型
 */
+ (NSString *)getHardParam
{
    NSMutableString *cpu = [[NSMutableString alloc] init];
    size_t size;
    cpu_type_t type;
    cpu_subtype_t subtype;
    size = sizeof(type);
    sysctlbyname("hw.cputype", &type, &size, NULL, 0);
    
    size = sizeof(subtype);
    sysctlbyname("hw.cpusubtype", &subtype, &size, NULL, 0);
    
    // values for cputype and cpusubtype defined in mach/machine.h
    if (type == CPU_TYPE_X86) {
        [cpu appendString:@"x86 "];
        // check for subtype ...
        
    } else if (type == CPU_TYPE_ARM) {
        [cpu appendString:@"ARM"];
        [cpu appendFormat:@",Type:%d", subtype];
    }
    return cpu;
}

/**
 获取CPU 核心数
 */
+ (int)getCountOfCores
{
    unsigned int ncpu;
    size_t len = sizeof(ncpu);
    sysctlbyname("hw.ncpu", &ncpu, &len, NULL, 0);
    return ncpu;
}

/**
 获取电池电量
 */
+ (CGFloat)getBatteryLevel
{
    return [UIDevice currentDevice].batteryLevel;
}

/**
 当前系统名称
 */
+ (NSString *)getSystemName
{
    return [UIDevice currentDevice].systemName;
}

/**
 当前系统版本号
 */
+ (NSString *)getSystemVersion
{
    return [UIDevice currentDevice].systemVersion;
}

/**
 上次开机时间
 */
+ (NSString *)getSystemUptime
{
    NSProcessInfo *info = [NSProcessInfo processInfo];
    NSDate *now = [NSDate date];
    NSTimeInterval interval = [now timeIntervalSince1970];
    return [self getDateStrFromTimeStep:interval - info.systemUptime];
}

+ (NSString *)getDateStrFromTimeStep:(long long)timestep {
    NSDate *timestepDate = [NSDate dateWithTimeIntervalSince1970:timestep];
    //1377044552->2013-08-21 08:22:32
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    //NSTimeZone* timeZone = [NSTimeZone timeZoneWithName:@"Asia/Shanghai"];
    NSTimeZone *timeZone = [NSTimeZone systemTimeZone];
    [formatter setTimeZone:timeZone];
    [formatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
    return [formatter stringFromDate:timestepDate];
}


/**
 判断cydia的URL scheme  是否越狱
 */
+ (BOOL)isJailBreak
{
    if ([[UIApplication sharedApplication] canOpenURL:[NSURL URLWithString:@"cydia://"]]) {
        return YES;
    }
    return NO;
}


#pragma mark - 网络信息
/**
 获取当前设备IP
 */
+ (NSString *)getDeviceIPAdress
{
    NSString *address = @"";
    struct ifaddrs *interfaces = NULL;
    struct ifaddrs *temp_addr = NULL;
    int success = 0;
    success = getifaddrs(&interfaces);
    if (success == 0) { // 0 表示获取成功
        temp_addr = interfaces;
        while (temp_addr != NULL) {
            if (temp_addr->ifa_addr->sa_family == AF_INET) {
                // Check if interface is en0 which is the wifi connection on the iPhone
                if ([[NSString stringWithUTF8String:temp_addr->ifa_name] isEqualToString:@"en0"]) {
                    // Get NSString from C String
                    address = [NSString stringWithUTF8String:inet_ntoa(((struct sockaddr_in *) temp_addr->ifa_addr)->sin_addr)];
                }
            }
            temp_addr = temp_addr->ifa_next;
        }
    }
    freeifaddrs(interfaces);
    return address;
}

/**
 获取运营商信息(IMSI)
 */
+ (CTCarrier *)getUserSubscriberCellularProvider;
{
    CTTelephonyNetworkInfo *info = [[CTTelephonyNetworkInfo alloc] init];
    CTCarrier *carrier = [info subscriberCellularProvider];
    return carrier;
}

/**
 获取手机运营商
 */
+ (NSString *)carrierName
{
    //获取本机运营商名称
    CTTelephonyNetworkInfo *info = [[CTTelephonyNetworkInfo alloc] init];
    CTCarrier *carrier = [info subscriberCellularProvider];
    //当前手机所属运营商名称
    NSString *carrierName;
    //先判断有没有SIM卡，如果没有则不获取本机运营商
    if (!carrier.isoCountryCode) {
        carrierName = @"无运营商";
    } else {
        carrierName = [carrier carrierName];
    }
    return carrierName;
}


#pragma mark - 电池信息
/**
 获取电池电量
 */
+ (NSString *)getSystemBatteryLevel
{
    //电池的状态是可监听的
    [UIDevice currentDevice].batteryMonitoringEnabled = YES;
    //获取当前电池的电量
//    NSLog(@"当前电池的电量百分比是%3.0f%%", ([[UIDevice currentDevice] batteryLevel]) * 100);
    NSString *batteryLevel = [NSString stringWithFormat:@"%.2f", [[UIDevice currentDevice] batteryLevel]];
    return batteryLevel;
}

/**
 当前电池状态
 */
+ (NSString *)getSystemBatteryStat
{
    //电池的状态是可监听的
    [UIDevice currentDevice].batteryMonitoringEnabled = YES;
    //获取电池的状态
    NSString *batteryStat = [NSString stringWithFormat:@"%lu", [UIDevice currentDevice].batteryState];
    return batteryStat;
}

/**
 是否已经充满电
 */
+ (BOOL)isBatteryStateFullCharged
{
    BOOL isFullCharged = NO;
    //电池的状态是可监听的
    [UIDevice currentDevice].batteryMonitoringEnabled = YES;
    //获取电池的状态
    if ([UIDevice currentDevice].batteryState == UIDeviceBatteryStateFull) {
        isFullCharged = YES;
    }
    return isFullCharged;
}

/**
 是否插入耳机
 */
+ (BOOL)isHeadsetPluggedIn
{
    AVAudioSessionRouteDescription *route = [[AVAudioSession sharedInstance] currentRoute];
    for (AVAudioSessionPortDescription *desc in [route outputs]) {
        if ([[desc portType] isEqualToString:AVAudioSessionPortHeadphones])
            return YES;
    }
    return NO;
}


#pragma mark - WiFi
/**
 获取Wifi信息
 */
+ (id)fetchSSIDInfo
{
    NSArray *ifs = (__bridge_transfer id) CNCopySupportedInterfaces();
    id info = nil;
    for (NSString *ifnam in ifs) {
        info = (__bridge_transfer id) CNCopyCurrentNetworkInfo((__bridge CFStringRef) ifnam);
        if (info && [info count]) {
            break;
        }
    }
    return info;
}

/**
 获取WIFI名字
 */
+ (NSString *)getWifiSSID
{
    return (NSString *) [self fetchSSIDInfo][@"SSID"];
}

/**
 获取WIFI的MAC地址
 */
+ (NSString *)getWifiBSSID
{
    return (NSString *) [self fetchSSIDInfo][@"BSSID"];
}

/**
 WiFi是否打开
 */
+ (BOOL)isWiFiEnabled
{
    NSCountedSet *cset = [NSCountedSet new];
    struct ifaddrs *interfaces;
    if (!getifaddrs(&interfaces)) {
        for (struct ifaddrs *interface = interfaces; interface; interface = interface->ifa_next) {
            if ((interface->ifa_flags & IFF_UP) == IFF_UP) {
                [cset addObject:[NSString stringWithUTF8String:interface->ifa_name]];
            }
        }
    }
    return [cset countForObject:@"awdl0"] > 1 ? YES : NO;
}




#pragma mark -存储信息
/**
 获取手机存储空间的大小
 */
+ (NSString *)getMaxspace;
{
    //可用大小
    struct statfs buf;
    long long freespace = -1;
    if (statfs("/var", &buf) >= 0) {
        freespace = (long long) (buf.f_bsize * buf.f_bfree);
    }
    NSString *sizeStr = [NSString stringWithFormat:@"%0.2f", (double) freespace / 1024 / 1024 / 1024];
    return sizeStr;
}

/**
 获取手机可用空间的大小
 */
+ (NSString *)getFreeSpace
{
    //总大小
    struct statfs buf;
    long long maxspace = 0;
    if (statfs("/", &buf) >= 0) {
        maxspace = (long long) buf.f_bsize * buf.f_blocks;
    }
    if (statfs("/private/var", &buf) >= 0) {
        maxspace += (long long) buf.f_bsize * buf.f_blocks;
    }
    NSString *sizeStr = [NSString stringWithFormat:@"%0.2f", (double) maxspace / 1024 / 1024 / 1024];
    return sizeStr;
}

/**
 获取磁盘已使用量
 */
+ (double)getUsedMemory
{
    task_basic_info_data_t taskInfo;
    mach_msg_type_number_t infoCount = TASK_BASIC_INFO_COUNT;
    kern_return_t kernReturn = task_info(mach_task_self(),
                                         TASK_BASIC_INFO,
                                         (task_info_t) &taskInfo,
                                         &infoCount);
    
    if (kernReturn != KERN_SUCCESS) {
        return NSNotFound;
    }
    return taskInfo.resident_size;
}

#pragma mark -内存
/**
 获得设备总内存
 */
+ (long long)getTotalMemoryBytes
{
    return [NSProcessInfo processInfo].physicalMemory;
}

/**
 获取内存已使用量
 */
+ (double)getMemory
{
    task_basic_info_data_t taskInfo;
    mach_msg_type_number_t infoCount = TASK_BASIC_INFO_COUNT;
    kern_return_t kernReturn = task_info(mach_task_self(),
                                         TASK_BASIC_INFO,
                                         (task_info_t) &taskInfo,
                                         &infoCount);
    if (kernReturn != KERN_SUCCESS) {
        return NSNotFound;
    }
    return taskInfo.resident_size;
}

//系统当前运行了多长时间
+ (NSTimeInterval)uptimeSinceLastBoot {
    //获取当前设备时间时间戳 受用户修改时间影响
    struct timeval now;
    struct timezone tz;
    gettimeofday(&now, &tz);
    //    NSLog(@"gettimeofday: %ld", now.tv_sec);
    
    //获取系统上次重启的时间戳 受用户修改时间影响
    struct timeval boottime;
    int mib[2] = {CTL_KERN, KERN_BOOTTIME};
    size_t size = sizeof(boottime);
    
    double uptime = -1;
    
    if (sysctl(mib, 2, &boottime, &size, NULL, 0) != -1 && boottime.tv_sec != 0) {
        //因为两个参数都会受用户修改时间的影响，因此它们想减的值是不变的
        uptime = now.tv_sec - boottime.tv_sec;
        uptime += (double) (now.tv_usec - boottime.tv_usec) / 1000000.0;
    }
    return uptime;
}


/**
 检测是否是模拟器
 */
+ (BOOL)checkSimulator {
    // "判断是真机还是模拟器
#if TARGET_OS_IPHONE
    //iPhone Device
    return NO;
#endif
    
#if TARGET_IPHONE_SIMULATOR
    //iPhone Simulator
    return YES;
#endif
}



#pragma mark - 获取CPU信息
+ (NSMutableDictionary *)getSystemCPUInfo {
    NSMutableDictionary *systemCPUInfo = [[NSMutableDictionary alloc] initWithCapacity:0];
    [systemCPUInfo setValue:[QGDeviceTool getHardParam] forKey:@"cpuABI"]; //CPU架构
    [systemCPUInfo setValue:[NSString stringWithFormat:@"%d", [QGDeviceTool getCountOfCores]] forKey:@"cpuCount"];
    [systemCPUInfo setValue:[QGDeviceTool getHardParam] forKey:@"cpuSpeed"];
    
    return systemCPUInfo;
}

#pragma mark - 设备标识符
+ (NSMutableDictionary *)getDeviceIdentifiers {
    NSMutableDictionary *identifiersInfo = [[NSMutableDictionary alloc] initWithCapacity:0];
    [identifiersInfo setValue:[self QGUUID] forKey:@"uuid"]; //uuid
    [identifiersInfo setValue:[NSString stringWithFormat:@"%d", [self getCountOfCores]] forKey:@"cpuCount"];
    [identifiersInfo setValue:[QGDeviceId idFromKeyChain] forKey:@"idfv"]; //idfv
    [identifiersInfo setValue:[QGDeviceId adid] forKey:@"idfa"];           //idfa
    
    return identifiersInfo;
}

#pragma mark -存储信息
+ (NSMutableDictionary *)getDeviceStorageInfo {
    NSMutableDictionary *storageInfo = [[NSMutableDictionary alloc] initWithCapacity:0];
    NSString *diskUsedStorageStr = [NSString stringWithFormat:@"%f", [self getUsedMemory]];
    NSDecimalNumber *storage = [NSDecimalNumber decimalNumberWithString:diskUsedStorageStr];
    [storageInfo setValue:[NSString stringWithFormat:@"%@G", [storage stringValue]] forKey:@"diskUsedStorage"];   // 磁盘已使用量
    [storageInfo setValue:[NSString stringWithFormat:@"%@G", [self getMaxspace]] forKey:@"totalStorage"];     //设备磁盘总容量
    [storageInfo setValue:[NSString stringWithFormat:@"%@G", [self getFreeSpace]] forKey:@"diskFreeStorage"]; //设备磁盘当前可用容量
    [storageInfo setValue:[NSString stringWithFormat:@"%lld", [self getTotalMemoryBytes]] forKey:@"totalMemory"]; //设备总内存
    NSString *usedMemoryStr = [NSString stringWithFormat:@"%f", [self getMemory]];
    NSDecimalNumber *memory = [NSDecimalNumber decimalNumberWithString:usedMemoryStr];
    [storageInfo setValue:[NSString stringWithFormat:@"%@", [memory stringValue]] forKey:@"usedMemory"]; //设备磁盘当前可用容量
    
    return storageInfo;
}

#pragma mark - 设备系统信息
+ (NSMutableDictionary *)getDeviceSystemInfo {
    NSMutableDictionary *systemInfo = [[NSMutableDictionary alloc] initWithCapacity:0];
    [systemInfo setValue:[self getDevicePlatformType] forKey:@"model"];                                    //机型(固件版本) 列如iPhone7,2
    [systemInfo setValue:@"iPhone" forKey:@"deviceType"];                                                      //设备类型
    [systemInfo setValue:[self getiPhoneName] forKey:@"deviceName"];                                       //设备名称
    [systemInfo setValue:[self getDeviceType] forKey:@"deviceModel"];                                      //机型(固件版本) 列如iPhone7,2
    [systemInfo setValue:[self getSystemUptime] forKey:@"systemUpTime"];                                   //上次开机时间, 保存的是Long型时间戳
    [systemInfo setValue:[NSString stringWithFormat:@"Apple %@", [self getDeviceType]] forKey:@"brand"];   //品牌
    [systemInfo setValue:[NSString stringWithFormat:@"iOS %@", [self getSystemVersion]] forKey:@"osName"]; //系统名称
    [systemInfo setValue:[self getSystemVersion] forKey:@"osVersion"];                                     //系统版本
    [systemInfo setValue:[NSNumber numberWithBool:[self checkSimulator]] forKey:@"simulator"];             //是否为模拟器
    CGRect rect = [[UIScreen mainScreen] bounds];
    [systemInfo setValue:[NSString stringWithFormat:@"%.f", rect.size.width] forKey:@"screenW"];            //屏幕宽度
    [systemInfo setValue:[NSString stringWithFormat:@"%.f", rect.size.width] forKey:@"screenH"];            //屏幕高度
    [systemInfo setValue:[NSNumber numberWithFloat:[UIScreen mainScreen].brightness] forKey:@"brightness"]; //屏幕亮度
    [systemInfo setValue:[NSNumber numberWithBool:[self isJailBreak]] forKey:@"breakFlag"];             //是否越狱
    [systemInfo setValue:@"CreditWallet" forKey:@"appName"];                                                //app名称
    [systemInfo setValue:XcodeAppVersion forKey:@"appVersion"];                                  //App 版本
    [systemInfo setValue:appChannel forKey:@"appChannel"];
    [systemInfo setValue:registerFrom forKey:@"registerFrom"];
    
    return systemInfo;
}

#pragma mark - 网络信息
+ (NSMutableDictionary *)getUserNetworkInfo {
    // 运营商信息
    NSString *carrier = [[self getUserSubscriberCellularProvider] carrierName];   //运营商信息
    NSString *mcc = [[self getUserSubscriberCellularProvider] mobileCountryCode]; //移动运营商国家码
    NSString *mnc = [[self getUserSubscriberCellularProvider] mobileNetworkCode]; //移动运营商网络码
    BOOL isHasTelephony = [[self getUserSubscriberCellularProvider] allowsVOIP];
    
    NSMutableDictionary *batteryInfo = [[NSMutableDictionary alloc] initWithCapacity:0];
    [batteryInfo setValue:[self getDeviceIPAdress] forKey:@"ip"];                                              //内网IP
    [batteryInfo setValue:carrier forKey:@"carrier"];                                                              //运营商信息
    [batteryInfo setValue:mcc forKey:@"simMcc"];                                                                   //移动运营商国家码
    [batteryInfo setValue:mnc forKey:@"simMnc"];                                                                   //移动运营商网络码
    [batteryInfo setValue:[NSNumber numberWithBool:YES] forKey:@"isHasCellular"];                                  //是否支持移动网络
    [batteryInfo setValue:[NSNumber numberWithBool:[self isWiFiEnabled]] forKey:@"isHasWiFi"];                 //是否发开WIFI 模块
    [batteryInfo setValue:[NSNumber numberWithBool:isHasTelephony] forKey:@"isHasTelephony"];                      //是否支持电话功能
    [batteryInfo setValue:[NSNumber numberWithBool:YES] forKey:@"isHasBluetooth"];                                 //是否支持蓝牙
    [batteryInfo setValue:[NSNumber numberWithBool:[self isHeadsetPluggedIn]] forKey:@"isHeadphonesAttached"]; //是否插入耳机
    
    return batteryInfo;
}

#pragma mark - 电池信息
+ (NSMutableDictionary *)getSystemBatteryInfo {
    BOOL isFullCharged = NO;
    
    //电池的状态是可监听的
    [UIDevice currentDevice].batteryMonitoringEnabled = YES;
    //获取电池的状态
    if ([UIDevice currentDevice].batteryState == UIDeviceBatteryStateFull) {
        isFullCharged = YES;
    }
    
    //获取当前电池的电量
    //    NSLog(@"当前电池的电量百分比是%3.0f%%",([[UIDevice currentDevice] batteryLevel]) *100);
    NSString *batteryLevel = [NSString stringWithFormat:@"%.2f", [[UIDevice currentDevice] batteryLevel]];
    //获取电池的状态
    NSString *batteryStat = [NSString stringWithFormat:@"%lu", [UIDevice currentDevice].batteryState];
    
    NSMutableDictionary *batteryInfo = [[NSMutableDictionary alloc] initWithCapacity:0];
    [batteryInfo setValue:batteryLevel forKey:@"batteryLevel"];                             //电池电量
    [batteryInfo setValue:batteryStat forKey:@"batteryStat"];                               //当前电池状态
    [batteryInfo setValue:[NSNumber numberWithBool:isFullCharged] forKey:@"isFullCharged"]; //是否已经充满电
    
    return batteryInfo;
}



@end
