//
//  QGCountDown.h
//  CreditWallet
//
//  Created by 张博 on 16/9/12.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface QGCountDown : NSObject

/**
 每秒回调一次

 @param PER_SECBlock 执行回调
 */
-(void)countDownWithPER_SECBlock:(void (^)(void))PER_SECBlock;

/**
 每 sec 秒执行一次
 
 @param sec 秒数
 @param isImmediately 是否立即调用一次
 @param PER_SECBlock 事件回调
 */
-(void)countDownWithSEC:(float)sec isImmediatelySelector:(BOOL)isImmediately eventBlock:(void (^)(void))PER_SECBlock;

/**
 *  主动销毁定时器
 */
-(void)destoryTimer;
@end
