//
//  UIView+Layer.m
//  LoanRecommend
//
//  Created by 张博 on 2018/9/9.
//  Copyright © 2018年 bo.zhang. All rights reserved.
//

#import "UIView+Layer.h"

@implementation UIView (Layer)

/**
 添加边框
 
 @param color 边框颜色
 @param width 宽度
 */
-(void)setBorder:(UIColor *)color width:(CGFloat)width
{
    CALayer *layer=self.layer;
    layer.borderColor=color.CGColor;
    layer.borderWidth=width;
}

/**
 给视图设置阴影

 @param color 颜色
 @param shadowRadius 模糊计算的半径,取平均值的半径,设置为0的话则为一个矩形块.
 @param shadowOffset 阴影的偏移量
 @param cornerRadius 圆角
 */
- (void)setShadowColor:(UIColor *)color shadowRadius:(CGFloat)shadowRadius shadowOffset:(CGSize)shadowOffset cornerRadius:(CGFloat)cornerRadius
{
    //阴影透明度
    self.layer.shadowOpacity = 0.5;
    if (color) {
        self.layer.shadowColor = color.CGColor;
    }
    if (shadowRadius > 0) {
        self.layer.shadowRadius = shadowRadius;
    }
    
    if (!CGSizeEqualToSize(CGSizeZero, shadowOffset)) {
        self.layer.shadowOffset = shadowOffset;
    }
    
    if (cornerRadius) {
        self.layer.cornerRadius = cornerRadius;
    }
}


@end
