//
//  UIFont+QGFont.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface UIFont (QGFont)
/**
 对应设计稿 light 样式字体
 @param fontSize 字体大小
 @return 字体实例
 */
+ (UIFont *)qg_lightFontOfSize:(CGFloat)fontSize;

/**
 对应设计稿 medium/Bold 样式字体
 @param fontSize 字体大小
 @return 字体实例
 */
+ (UIFont *)qg_mediumFontOfSize:(CGFloat)fontSize;

/**
 对应设计稿 Semibold 样式字体
 @param fontSize 字体大小
 @return 字体实例
 */
+ (UIFont *)qg_semiboldFontOfSize:(CGFloat)fontSize;

/**
 对应设计稿 regular 样式字体
 @param fontSize 字体大小
 @return 字体实例
 */
+ (UIFont *)qg_regularFontOfSize:(CGFloat)fontSize;

/**
 数字专用字体
 @param fontSize 字体大小
 @return 字体实例
 */
+ (UIFont *)qg_numberFontOfSize:(CGFloat)fontSize;

@end

NS_ASSUME_NONNULL_END
