//
//  UIColor+QGColor.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "UIColor+QGColor.h"

@implementation UIColor (QGColor)

/**
 导航栏默认字体颜色
 */
+ (UIColor *)navigationTitleColor
{
    return [UIColor textColor3333];
}

/**
 导航栏默认背景色
 */
+ (UIColor *)navigationBarColor
{
    return [UIColor whiteColor];
}

/**
 导航栏的tintColor  左右侧按钮/文案颜色
 */
+(UIColor*)navigationTintColor
{
    return [UIColor textColor3333];
}

/**
 产品色-用于大面积使用（如顶部背景色、按钮颜色）
 */
+ (NSArray *)gradientColors
{
    return [self gradientColorsAlpha:1];
}

/// 推广会员相关的渐变色
+ (NSArray *)gradientColorsE9B176ToF2CD8B:(CGFloat)alpha
{
    return @[(id)[UIColor colorWithHexString:@"E9B176" alpha:alpha].CGColor,(id)[UIColor colorWithHexString:@"F2CD8B" alpha:alpha].CGColor];
}

/// 推广会员相关的渐变色
+ (NSArray *)gradientColorsE9B176ToF2CD8B
{
    return [self gradientColorsE9B176ToF2CD8B:1];
}


/**
 产品色-用于大面积使用（如顶部背景色、按钮颜色）

 @param alpha 透明度
 */
+ (NSArray *)gradientColorsAlpha:(CGFloat)alpha
{
    return @[(id)[UIColor colorWithHexString:@"FF5A4B" alpha:alpha].CGColor,(id)[UIColor colorWithHexString:@"FF6E73" alpha:alpha].CGColor];
}


/**
 阳阳定的新的主体色
 */
+ (UIColor *)yyMainThemeColor
{
    return [UIColor colorWithHexString:@"FF5A4B"];
}

/**
 产品色-用于特别需要强调的文字或者按钮和icon （旧商城规则）
 （如tab栏文字，弹窗按钮文字等）
 */
+ (UIColor *)mainThemeColor
{
    return [UIColor colorWithHexString:@"B44B4D"];
}

/**
 用于toast、消息提示背景色
 */
+ (UIColor *)toastBackgroundColor
{
    return [UIColor colorWithHexString:@"FFE6AF"];
}

/**
 用于toast、消息提示等文字颜色
 */
+ (UIColor *)toastTextColor
{
    return [UIColor colorWithHexString:@"8C6E37"];
}

/**
 小面积使用，用于需要特别强调的文字
 （如逾期提示等）
 */
+ (UIColor *)textColorF41C1C
{
    return [UIColor colorWithHexString:@"F41C1C"];
}

/**
 主要用于背景蒙层，透明度为40%
 （如所有弹窗和选择模块等）
 */
+ (UIColor *)backgroundColor0000
{
    return [UIColor colorWithHexString:@"000000" alpha:0.4];
}

/**
 主要用于主文案以及列表内容等
 （如首页借款数值以及期限数值等）
 */
+ (UIColor *)textColor3333
{
    return [UIColor colorWithHexString:@"333333"];
}

/**
 主要用于副文案或者不用强调的标题
 （如列表的内容文案等）
 */
+ (UIColor *)textColor6666
{
    return [UIColor colorWithHexString:@"666666"];
}

/**
 主要用于内容很多的附属文案
 （如列表的输入提示文案等）
 */
+ (UIColor *)textColor9999
{
    return [UIColor colorWithHexString:@"999999"];
}

/**
 主要用于列表分割线的颜色
 */
+ (UIColor *)lineSeparatorColorDCDC
{
    return [UIColor colorWithHexString:@"DCDCDC"];
}

/**
 主要用于模块分割线的颜色
 */
+ (UIColor *)moduleSeparatorColorF7F7
{
    return [UIColor colorWithHexString:@"F7F7F7"];
}

+ (UIColor *)imageBackgroundColorF0F0F0
{
    return [UIColor colorWithHexString:@"F0F0F0"];
}

/**
 根据HexString创建颜色
 */
+ (UIColor *)colorWithHexString:(NSString *)hexString
{
    return [self colorWithHexString:hexString alpha:1.0f];
}

+(UIColor*)lifePayBackGroudColor{
    return [UIColor colorWithHexString:@"F4F4F4"];
}

/**
 *  输入框边框颜色
 */
+(UIColor*)mainBorderColor
{
    return [UIColor colorWithHexString:@"979797"];
}


/// 阴影色
+ (UIColor *)shadowColor
{
    return [UIColor colorWithHexString:@"333333" alpha:0.2];
}

/**
 根据HexString创建颜色
 */
+ (UIColor *)colorWithHexString:(NSString *)hexString alpha:(CGFloat)alpha
{
    NSString *cString = [[hexString stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]] uppercaseString];
    if ([cString length] < 6) {
        return [UIColor clearColor];
    }
    // strip 0X if it appears
    //如果是0x开头的，那么截取字符串，字符串从索引为2的位置开始，一直到末尾
    if ([cString hasPrefix:@"0X"]) {
        cString = [cString substringFromIndex:2];
    }
    //如果是#开头的，那么截取字符串，字符串从索引为1的位置开始，一直到末尾
    if ([cString hasPrefix:@"#"]) {
        cString = [cString substringFromIndex:1];
    }
    if ([cString length] != 6) {
        return [UIColor clearColor];
    }
    // Separate into r, g, b substrings
    NSRange range;
    range.location = 0;
    range.length = 2;
    //r
    NSString *rString = [cString substringWithRange:range];
    //g
    range.location = 2;
    NSString *gString = [cString substringWithRange:range];
    //b
    range.location = 4;
    NSString *bString = [cString substringWithRange:range];
    // Scan values
    unsigned int r, g, b;
    [[NSScanner scannerWithString:rString] scanHexInt:&r];
    [[NSScanner scannerWithString:gString] scanHexInt:&g];
    [[NSScanner scannerWithString:bString] scanHexInt:&b];
    return [UIColor colorWithRed:((float)r / 255.0f) green:((float)g / 255.0f) blue:((float)b / 255.0f) alpha:alpha];
}

@end
