//
//  UICollectionView+RefreshControl.m
//  VirtualPayment
//
//  Created by silicn on 2020/3/15.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "UICollectionView+RefreshControl.h"
#import "objc/message.h"
#import "MJRefresh.h"
#import "UIColor+QGColor.h"
#import "UIFont+QGFont.h"


@interface UICollectionView ()

@property (nonatomic, copy)RefreshBlock refreshBlock;

@end

@implementation UICollectionView (RefreshControl)

- (void)setPageNum:(NSInteger)pageNum
{
    objc_setAssociatedObject(self, @selector(pageNum), @(pageNum), OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSInteger)pageNum{
    return [objc_getAssociatedObject(self, _cmd) integerValue];
}

- (void)setPageCount:(NSInteger)pageCount
{
    objc_setAssociatedObject(self,@selector(pageCount) , @(pageCount), OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSInteger)pageCount{
    return [objc_getAssociatedObject(self, _cmd) integerValue];
}

- (void)setRefreshBlock:(RefreshBlock)refreshBlock
{
    objc_setAssociatedObject(self, @selector(refreshBlock), refreshBlock, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (RefreshBlock)refreshBlock
{
    return objc_getAssociatedObject(self, _cmd);
}

- (QGRefreshNomalHeader *)addRefreshWithHandle:(RefreshBlock)refreshingBlock
{
    if (self.mj_header == nil) {
        QGRefreshNomalHeader *header = [QGRefreshNomalHeader headerWithRefreshingBlock:^{
            if (refreshingBlock) {refreshingBlock(YES);}
        }];
        [header setTitle:@"下拉刷新" forState:MJRefreshStateIdle];
        [header setTitle:@"努力刷新中..." forState:MJRefreshStateRefreshing];
        [header setTitle:@"松开刷新" forState:MJRefreshStatePulling];
        [header setTitle:@"松开刷新..." forState:MJRefreshStateWillRefresh];
        self.mj_header = header;
    }
    return (QGRefreshNomalHeader *)self.mj_header;
}

- (void)beginHeaderRefresh
{
    if (self.mj_footer.state == MJRefreshStateRefreshing) {
        [self.mj_footer endRefreshing];
    }
    [self.mj_header beginRefreshing];
    
}

- (void)initFooter
{
    if (self.mj_footer == nil) {
        __weak typeof(self) weakSelf = self;
        MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
            if (weakSelf.refreshBlock) {weakSelf.refreshBlock(NO);}
        }];
        self.mj_footer = footer;
        [footer setTitle:@"上拉加载"forState:MJRefreshStateIdle];
        [footer setTitle:@"-没有更多数据了-"  forState:MJRefreshStateNoMoreData];
        footer.stateLabel.textColor = [UIColor textColor9999];
        footer.stateLabel.font = [UIFont qg_lightFontOfSize:14];
        [footer setTitle:@"正在加载..." forState:MJRefreshStateRefreshing];
        [footer setTitle:@"松开拉取" forState:MJRefreshStateWillRefresh];
        [footer setTitle:@"松开拉取" forState:MJRefreshStatePulling];
        
    }
}

/// 结束下拉刷新或者上拉加载更多 （用于明确知道是否有下一页）
/// @param isBusinessSuccess 请求成功，并且业务状态为0000时为YES 其余都为NO
/// @param hasNext 是否有下一页
- (void)endRefreshWithBusinessSuccess:(BOOL)isBusinessSuccess hasNext:(BOOL)hasNext
{
    [self endRefresh];
    
    //如果业务逻辑处理失败，或者请求失败 后续不做处理
    if (!isBusinessSuccess) {
       return;
    }

    //检测是否有上拉刷新，没有则添加
    if (self.mj_footer == nil && hasNext){
       [self initFooter];
    }
    
    //如果有更多数据，页码自增，否则展示没有更多数据了
    if (hasNext) {
        self.pageNum += 1;
    }
    else
    {
        [self.mj_footer endRefreshingWithNoMoreData];
        [self removeFooterLoadData];
    }
    
}

- (void)endRefresh
{
    //处理上下拉逻辑
    if (self.mj_header.state == MJRefreshStateRefreshing) {
       [self.mj_header endRefreshingWithCompletionBlock:NULL];
    }

    if (self.mj_footer.state == MJRefreshStateRefreshing) {
       [self.mj_footer endRefreshingWithCompletionBlock:NULL];
    }
    
}

- (void)removeFooterLoadData
{
    if (self.mj_footer) {
         [self.mj_footer removeFromSuperview];
         self.mj_footer = nil;
    }
}


@end
