//
//  QGAppStatic.h
//  VirtualPayment
//
//  Created by 张博 on 2019/11/8.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#ifndef QGAppStatic_h
#define QGAppStatic_h
#import "QGAppMacro.h"


///根据375尺寸的设计图等比例缩放
FOUNDATION_STATIC_INLINE CGFloat convertEqualScaleFrom375(CGFloat value) {
    static CGFloat scaleFrom375 = 0;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        scaleFrom375 = [UIScreen mainScreen].bounds.size.width / 375.0f;
    });
    return ceilf(value * scaleFrom375);
}


/// 根据屏幕计算出0.5高度的线应显示的实际高度
/// 直接设置0.5在同一设备下极小几率出现线条粗细不一致
FOUNDATION_STATIC_INLINE CGFloat QGLineHeight () {
    static CGFloat QGLineHeight = 0;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        CGFloat scale = [UIScreen mainScreen].scale;
        QGLineHeight = fmodf(scale, 2) == 0 ? 0.5 : ((scale + 1) / 2) / scale;
    });
    return QGLineHeight;
}


FOUNDATION_STATIC_INLINE NSString *bundle_type(){
    if ([XcodeAppBundleIdentifier isEqualToString:@"com.quantgroup.test"]) {
        return @"apptybmios";
    }else if ([XcodeAppBundleIdentifier isEqualToString:@"com.baitiao.www"]){
        return @"zxh";
    }
    return nil;
}

FOUNDATION_STATIC_INLINE NSString *face_appid(){

    if ([XcodeAppBundleIdentifier isEqualToString:@"com.quantgroup.test"]) {
#ifdef FormalEnviroment
        return @"IDA4OaM0";
#else
        return @"TIDAhl44";
#endif
    }else if ([XcodeAppBundleIdentifier isEqualToString:@"com.baitiao.www"]){
#ifdef FormalEnviroment
        return @"IDAye2GW";
#else
        return @"TIDAup2x";
#endif
    }

    return nil;
}

FOUNDATION_STATIC_INLINE NSString *face_license(){

    if ([XcodeAppBundleIdentifier isEqualToString:@"com.quantgroup.test"]) {
#ifdef FormalEnviroment
        return @"ArN/UUPdRg6ClpWWAhJZzFtJ6O6XOZuTFw/9MZ2SZzSNNhk4oXsLHWhvocYHvpEMR8OhBzecR5W38/E/meP5oGtSg6WVOwypS+cBvinAT12CTLLWl85Rs6POJLFyQiMAYBG/Vh0KbL4N5KdpFvOl+FYciKpi21CUE3eE2brTWhpaEj4DL4WFdxU2NhJaTAtqThbP7SrFYBE3F7BWCuf8TALZLkZo0PjouNRk+dDwVOXt6SjilXa98Y8229Aj89J4md9m49DqzeD5UgkCA7fux/D7sku2/ldgkHieDSbooLBqnUCnJUzSylR5BQOAmS7Br55XbYWgek7Z73UtqZJGmg==";
#else
        return @"ArN/UUPdRg6ClpWWAhJZzFtJ6O6XOZuTFw/9MZ2SZzSNNhk4oXsLHWhvocYHvpEMR8OhBzecR5W38/E/meP5oGtSg6WVOwypS+cBvinAT12CTLLWl85Rs6POJLFyQiMAYBG/Vh0KbL4N5KdpFvOl+FYciKpi21CUE3eE2brTWhqqqveM+/KmzAMtEsCdsCiM2ABQKC3Oy5H23tHqhUBf49uSWNeXlmzpDDDv6Z5V0P8cfC17tTAXvBBAr5ESjQhwnUscb4Rkqu5vlyodhqmHkGUG9UyJ6qqzAPtno5lcGaNymculY81Ug1rVxw5TnC2wmpY1jJSoJfuhVEjHJMr0yg==";
#endif
    }else if ([XcodeAppBundleIdentifier isEqualToString:@"com.baitiao.www"]){
#ifdef FormalEnviroment
            return @"QPwcsmvi5pUWnAPwSzqOZhUGIynQBpr/6GVEoEvd8bY6jt2Tz9Vb/YzUfGGuFB8lSGHMT00AryZMl/y54DbBwVav56xq1UqzuqIHq11EjrIY7nEjY71HnAR0t8qrosS/wiLUMqScEudve3u5X+7pdSmqMjCe+nhWtgz1wKl//zCTNKv4gEQg/A8ZKG3+K1Rg8GYQ3hnAKXRkxHfTC4pwzdncg18AlPTA9HJKCzf3tXRZBhSLgyEE1LwoAAFvO6bnn/glh8QglwZblYNI7wt2gQdgM5eQnUqg85Y7GQ+uqtcFap9xpqcnGvx52cMebZciCOXiHa6fisvM8cNYJVnkmw==";
#else
            return @"QPwcsmvi5pUWnAPwSzqOZhUGIynQBpr/6GVEoEvd8bY6jt2Tz9Vb/YzUfGGuFB8lSGHMT00AryZMl/y54DbBwVav56xq1UqzuqIHq11EjrIY7nEjY71HnAR0t8qrosS/wiLUMqScEudve3u5X+7pdSmqMjCe+nhWtgz1wKl//zA2O1dhFLUTOXT5gtesT5V1W0FGGj+EUEs8mbqjD9dlMvv2S2CtTQXKNorILzpMWuCyMKJByJrzbXyA8G96s3+IVaJOtuOvyAbwX09YD8HlArN/J33Zp44pe2IRHF+D90xlx7Cggp/ax8j+vjQYrHlXppj6zJd6SuClx27Rsg62Iw==";
#endif
       
    }
    return nil;
}


#endif /* QGAppStatic_h */
