//
//  QGAppMacro.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#ifndef QGAppMacro_h
#define QGAppMacro_h

///log
/*
#ifdef DEBUG
#define NSLog(format, ...) printf("\n[%s] %s [第%d行] %s\n", __TIME__, __FUNCTION__, __LINE__, [[NSString stringWithFormat:format, ## __VA_ARGS__] UTF8String]);
#else
#define NSLog(format, ...)
#endif
*/



///创建静态变量
#define DEFINE_STR(key, value) static NSString *const key = value;

#define iOS7 [[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0
#define iOS8 [[[UIDevice currentDevice] systemVersion] floatValue] >= 8.0
#define iOS10 [[[UIDevice currentDevice] systemVersion] floatValue] >= 10.0
#define iOS10_3 [[[UIDevice currentDevice] systemVersion] floatValue] >= 10.3
#define iOS11 [[[UIDevice currentDevice] systemVersion] floatValue] >= 11.0
#define iOS13 [[[UIDevice currentDevice] systemVersion] floatValue] >= 13.0

#define MAINSCREEN_WIDTH MIN([UIScreen mainScreen].bounds.size.width, [UIScreen mainScreen].bounds.size.height)
#define MAINSCREEN_HEIGHT MAX([UIScreen mainScreen].bounds.size.width, [UIScreen mainScreen].bounds.size.height)

// iPhone5/5c/5s/SE 4英寸 屏幕宽高：320*568点 屏幕模式：2x 分辨率：1136*640像素
#define isiPhone5or5cor5sorSE (MAINSCREEN_WIDTH == 320.0)

///屏幕缩放比例
#define Screen_Scaling (MAINSCREEN_WIDTH/375.0)

///版本号
//#define XcodeAppVersion [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleShortVersionString"]

//此处写死版本号，每次发版手动升级版本号
//因为该包发版依赖于替换旧包，所以真实版本号很高。此处手动维护是因为产品要求版本号比较低。
#define XcodeAppVersion @"3.0.10"

//引导图版本号，每次替换引导图后修改此版本号
#define GuideKeyVersion @"3.0.00"

//闪屏图片版本号，每次替换闪屏图后更改此版本号，清理闪屏缓存
#define LaunchScreenVersion @"3.0.00"

#define XcodeAppBundleIdentifier [[NSBundle mainBundle] bundleIdentifier]
///渠道
#define appChannel [QGToolsConfig getAppKeyWithToolsType:QGToolsConfigTypeAppChannel]
#define registerFrom @"159860"

#define WXAppId @"wx1bd4da7708f11ef3"
#define WXSecret @"83477d4fb1d911560a26d93f54887c14"

/// 极光推送AppKey
#define kJPushAppKey @"3591ee0bb906b9be14614404"



static NSString *const kDefaultIconUrl = @"http://7xodoz.dl1.z0.glb.clouddn.com/app/share/logo_120.png";
//Tencent
static NSString *const kTencentAppID = @"1108767784";
static NSString *const kTencentSchemeKey = @"tencent1108767784";


#define kPasteboardCurrentContentKey @"kPasteboardCurrentContentKey"

//字节跳动APM
#define ByteDanceApmAppID @"173771"
//客服url
#define VCCServiceUrl @"https://www.sobot.com/chat/h5/index.html?sysNum=1364e193640f4fef909bf66d46b4c282&source=2&partenerid={phone}&tel={phone}"

///隐私政策协议
#define VCCPrivacyAgreement @"http://pages.xyqb.com/zhen-xiang-sheng-huo-yin-si-zheng-ce/"

///用户注册协议
#define VCCRegisterAgreement @"http://pages.xyqb.com/zhen-xiang-sheng-huo-yong-hu-zhu-ce-xie-yi/"

///需要打线上包时解开注释
//#define FormalEnviroment @"YES"

// 通过判断“FormalEnviroment”是否已经定义，区分后配置正式环境或测试环境。
#ifdef FormalEnviroment
    #define AppBackendBaseUrl @"https://mapi.xyqb.com/vcc" // 正式环境
    #define AppTalosBaseUrl @"https://talos.xyqb.com"  //talos 正式环境

    #define AuthBaseUrl @"https://auth.quantgroup.cn"
    #define kApsForProduction @"1"
    /// 百川授权回调结果页面查询标识URL
    /// 这个地址是URL的path
    #define kBaiChuanAuthResultIdentification @"/bindTaobao/callback"

    ///提额攻略
    #define DrawStrategyUrl @"https://vcc.xyqb.com/drawStrategy"
    ///相机协议
    #define CameraRuleUrl @"https://vcc.xyqb.com/cameraRule"
    ///相册协议
    #define PhotoRuleUrl @"https://vcc.xyqb.com/photoRule"
    ///麦克风协议
    #define MicroPhoneRuleUrl @"https://vcc.xyqb.com/microphoneRule"
    /// 地理位置信息协议
    #define kGPSRuleUrl @"https://vcc.xyqb.com/addressRule"
    ///用户更正删除信息
    #define ModifyDeleteMessage @"https://vcc.xyqb.com/modifyDeleteMessage"

#else
    #define AppBackendBaseUrl @"http://mapi-vcc.liangkebang.net/vcc" // 测试环境
    #define AppTalosBaseUrl @"http://talos-vcc.liangkebang.net"  //talos 测试环境

    #define AuthBaseUrl @"http://operator.liangkebang.com"
    #define kApsForProduction @"0"
    /// 百川授权回调结果页面查询标识URL
    /// 这个地址是URL的path
    #define kBaiChuanAuthResultIdentification @"/bindTaobao/callback"

    ///提额攻略
    #define DrawStrategyUrl @"https://vcc-ui-vcc.liangkebang.net/drawStrategy"
    ///相机协议
    #define CameraRuleUrl @"https://vcc-ui-vcc.liangkebang.net/cameraRule"
    ///相册协议
    #define PhotoRuleUrl @"https://vcc-ui-vcc.liangkebang.net/photoRule"
    ///麦克风协议
    #define MicroPhoneRuleUrl @"https://vcc-ui-vcc.liangkebang.net/microphoneRule"
    /// 地理位置信息协议
    #define kGPSRuleUrl @"https://vcc-ui-vcc.liangkebang.net/addressRule"
    ///用户更正删除信息
    #define ModifyDeleteMessage @"https://vcc-ui-vcc.liangkebang.net/modifyDeleteMessage"

   
#endif










 



#endif /* QGAppMacro_h */
