//
//  IphoneXSeries.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "DeviceAdaptation.h"

@implementation DeviceAdaptation

///状态栏的高度
+ (CGFloat)getStatusBarHeight
{
    CGRect statusRect = [[UIApplication sharedApplication] statusBarFrame];
    return CGRectGetHeight(statusRect);
}

///状态栏+导航栏的高度
+ (CGFloat)getNavBarAndStatusBarHeight
{
    CGFloat height = [self getStatusBarHeight] + 44;
    return (height);
}

///是否是iPhone X系列
+ (BOOL)isIphoneXSeries
{
    BOOL isIphoneXSeries = NO;
    if (UIDevice.currentDevice.userInterfaceIdiom != UIUserInterfaceIdiomPhone) {
        return isIphoneXSeries;
    }
    
    if (@available(iOS 11.0, *))
    {
        UIWindow *mainWindow = [[[UIApplication sharedApplication] delegate] window];
        if (mainWindow.safeAreaInsets.bottom > 0.0) {
            isIphoneXSeries = YES;
        }
    }
    return isIphoneXSeries;
}

///安全区域的高度
+ (CGFloat)getBottomSafeAreaHeight
{
    CGFloat height = 0;
    if (@available(iOS 11.0, *))
    {
        UIWindow *mainWindow = [[[UIApplication sharedApplication] delegate] window];
        if (mainWindow.safeAreaInsets.bottom > 0.0)
        {
            height = mainWindow.safeAreaInsets.bottom;
        }
    }
    return MAX(0, height);
}

///tabbar高度
+ (CGFloat)getTabBarHeight
{
    return 49 + [self getBottomSafeAreaHeight];
}


static NSTimeInterval lastClickTime = 0.0;
+ (BOOL)canClick {
    NSTimeInterval nowTime = [[NSProcessInfo processInfo] systemUptime];
    if (nowTime - lastClickTime >= 0.8) {
        lastClickTime = nowTime;
        return YES;
    }
    return NO;
}

@end
