//
//  UIViewController+Gesture.m
//  CreditWallet
//
//  Created by 张博 on 16/8/26.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "UIViewController+Gesture.h"
#import <objc/runtime.h>

static const char * closePopGestureKey = "closePopGesture";

@implementation UIViewController (Gesture)

#pragma mark - Setter
- (void)setIsClosePopGesture:(BOOL)isClosePopGesture
{
    objc_setAssociatedObject(self,closePopGestureKey, [NSNumber numberWithBool:isClosePopGesture], OBJC_ASSOCIATION_ASSIGN);
}


- (void)setMaxAllowedInitialDistance:(CGFloat)maxAllowedInitialDistance
{
    objc_setAssociatedObject(self, @selector(maxAllowedInitialDistance), @(maxAllowedInitialDistance), OBJC_ASSOCIATION_RETAIN);
}


#pragma mark - Getter

- (BOOL)isClosePopGesture
{
    BOOL result = [objc_getAssociatedObject(self, closePopGestureKey) boolValue];
    return result;
}

- (CGFloat)maxAllowedInitialDistance
{
    CGFloat result = [objc_getAssociatedObject(self, _cmd) floatValue];
    return result;
}















@end
