//
//  UIViewController+CommonConfig.h
//  LoanRecommend
//
//  Created by 张博 on 2018/8/15.
//  Copyright © 2018年 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "UIButton+QGAdd.h"
#import "QGDefaultView.h"

@interface UIViewController (CommonConfig)


/**
 *  自定义返回按钮(黑) 默认执行pop/dismsss
 */
-(void)custemLeftDefaultBarButtonItem;

/**
 *  自定义返回按钮(白色) 默认执行pop/dismsss
 */
-(void)custemLeftWhiteBarButtonItem;

/**
 自定义返回按钮 默认执行pop/dismsss
 如果实现了点击的Block就需要自己调用返回函数
 @param actionBlock 点击事件
 */
-(void)custemLeftDefaultBarButtonItemWithTouchAction:(ButtonActionBlock)actionBlock;


/**
 自定义左侧按钮 默认执行pop/dismsss
 @param imgName 图片名称
 @param actionBlock 点击事件
 @return 按钮实例类
 */
- (UIButton *)customLeftBarButtonItemWithImgName:(NSString *)imgName action:(ButtonActionBlock)actionBlock;


/**
 自定义右侧navItem Button
 ❗️图片和标题二选一，图片优先级高
 @param title 标题
 @param imageName 图片
 @param actionBlock 点击回调
 @return 按钮实力类
 */
-(UIButton *)custemRightBarButtonItemWithTitle:(NSString *)title imageName:(NSString *)imageName action:(ButtonActionBlock)actionBlock;


/**
 *  从NIB中加载cell 如果有则出列一个cell
 */
-(UITableViewCell *)getCellFromNibName:(NSString *)nibName dequeueTableView:(UITableView *)tableView;

/**
 兼容旧代码
 */
-(UITableViewCell *)getCellFromNibName:(NSString *)nibName objectAtIndex:(NSUInteger)index dequeueTableView:(UITableView *)tableView;

/**
 *  根据类名出列Cell
 */
-(UITableViewCell *)getCellFromClassName:(NSString *)className dequeueTableView:(UITableView *)tableView;


/**
 调用起来登录页面
 */
- (void)showLoginViewController;

/**
 *  显示登录控制器，并且有回调
 */
- (void)showLoginViewControllerCompletion:(void(^)())successBlock;

/// 显示登录控制器
/// @param successBlock 成功回调
/// @param cancleBlock 取消回调
- (void)showLoginViewControllerCompletion:(void(^)())successBlock cancleBlock:(dispatch_block_t)cancleBlock;

/**
 展示出错误页面重新加载
 
 @param reloadBlock 重新加载回调
 */
- (QGDefaultView *)showErrorPageReloadBlock:(dispatch_block_t)reloadBlock;

/**
 展示没有信息页面
 
 @param message 提示文案
 @param imageName 提示图片
 */
- (QGDefaultView *)showNoInfoViewWithMessage:(NSString *)message imageName:(NSString *)imageName buttonTitle:(NSString *)buttonTitle reloadBlock:(dispatch_block_t)reloadBlock;

/**
 跳转到指定网页

 @param url 网页地址
 */
- (void)navigationToWeb:(NSString *)url;


/// 跳转到协议链接 http || xyqb
- (void)navigationToAllSupportUrl:(NSString *)navUrl;

/**
 从导航栏中移除自己
 */
- (void)removeSelfFromNavigationController;
@end
