//
//  UINavigationBar+Background.m
//  NavGestureAnimation
//
//  Created by 张博 on 16/10/17.
//  Copyright © 2016年 zhangbo. All rights reserved.
//

#import "UINavigationBar+Background.h"
@implementation UINavigationBar (Background)

- (void)clearBackground
{
    [self setShadowImage:[UIImage new]];
    [self setBackgroundImage:[UIImage new] forBarMetrics:UIBarMetricsDefault];
}


/**
 *  还原默认设置
 */
- (void)ex_reset
{
    self.shadowImage = nil;
    [self setTranslationY:0];
}


/**
 *  设置背景视图的偏移量
 *
 *  @param translationY 偏移量
 */
- (void)setTranslationY:(CGFloat)translationY
{
    self.transform = CGAffineTransformMakeTranslation(0, translationY);
}


/**
 *  子视图的透明度
 *
 *  @param alpha 透明度
 */
- (void)ex_setElementsAlpha:(CGFloat)alpha
{
    [[self valueForKey:@"_leftViews"] enumerateObjectsUsingBlock:^(UIView *view, NSUInteger i, BOOL *stop) {
        view.alpha = alpha;
    }];
    
    [[self valueForKey:@"_rightViews"] enumerateObjectsUsingBlock:^(UIView *view, NSUInteger i, BOOL *stop) {
        view.alpha = alpha;
    }];
    
    UIView *titleView = [self valueForKey:@"_titleView"];
    titleView.alpha = alpha;
    
    //    when viewController first load, the titleView maybe nil
    [[self subviews] enumerateObjectsUsingBlock:^(UIView *obj, NSUInteger idx, BOOL *stop) {
        if ([obj isKindOfClass:NSClassFromString(@"UINavigationItemView")]) {
            obj.alpha = alpha;
            *stop = YES;
        }
    }];
    
}


@end
