//
//  QGBaseWebViewController+FaceSDK.m
//  VirtualPayment
//
//  Created by silicn on 2020/1/3.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaseWebViewController+FaceSDK.h"
#import "QGFaceVerifyManager.h"
#import "AccessPermissionsManager.h"

@implementation QGBaseWebViewController (FaceSDK)

/// 开启OCR验证
/// @param valueDit 参数
- (void)openfaceIDIDCard:(NSDictionary *)valueDit
{
#if !TARGET_IPHONE_SIMULATOR
       NSDictionary *params = valueDit[@"data"];
       /// true 是人像面  false 是反面
        BOOL isShootPagePortrait = [params[@"isShootPagePortrait"] boolValue];
        NSString *authToken = [params objectForKey:@"auth-token"];
        //统计发起OCR认证的人数
        [self ocrEventAnalyticsWithSide:isShootPagePortrait desc:@"启动OCR"];
        __weak typeof(self) weakSelf = self;
        //检测相机权限
        AccessPermissionsManager * permissionManager = [[AccessPermissionsManager alloc]init];
        [permissionManager requestCameraAuthorization:^{
            [weakSelf startIDCardCheck:isShootPagePortrait authToken:authToken];
        }];
#else
        NSLog(@"当前运行的是模拟器");
#endif
}

///开始身份证检测
- (void)startIDCardCheck:(BOOL)isShootPagePortrait authToken:(NSString *)authToken
{
#if !TARGET_IPHONE_SIMULATOR
    __weak typeof(self) weakSelf = self;
       QGFaceVerifyManager *manager = [QGFaceVerifyManager shareInstance];
       /// 启动OCR服务
       
       [manager startOCRServiceWithType:isShootPagePortrait ? QGOCRIDCardTypeFrontSide : QGOCRIDCardTypeBackSide
                           ocrAuthToken:authToken
                                success:^(WBIDCardInfoModel * _Nonnull model) {
           if (model == nil)  return ;
           /// 回传信息给JS
           [weakSelf callBackToJSWithModel:model isShootPagePortrait:isShootPagePortrait];
           /// 统计成功信息
           [weakSelf ocrEventAnalyticsWithSide:isShootPagePortrait desc:@"OCR识别成功"];
       } failure:^(NSError *error,NSString *orderNo){
           /// 识别失败
           [weakSelf callBackToJSWithError:error orderNo:orderNo side:isShootPagePortrait];
           [weakSelf ocrEventAnalyticsWithSide:isShootPagePortrait desc:@"OCR识别失败"];
       }];
#else
    NSLog(@"当前运行的是模拟器");
#endif
}


/// OCR失败的回传
/// @param error 错误信息
/// @param orderNo 错误的orderNo
/// @param isShootPagePortrait 正反面
- (void)callBackToJSWithError:(NSError *)error orderNo:(NSString *)orderNo side:(BOOL)isShootPagePortrait
{
    if (error && orderNo) {
        NSMutableDictionary *parmas = [NSMutableDictionary dictionary];
        [parmas setObject:@"faceIDIDCardCallBack" forKey:@"event"];                  /// 事件名
        /// 内部公共信息
        NSMutableDictionary *info = [NSMutableDictionary dictionary];
        [info setObject:@(isShootPagePortrait) forKey:@"isShootPagePortrait"];       /// 人像面
        [info setObject:orderNo ? orderNo :@"" forKey:@"orderNo"];                   /// 本次识别的订单号
        [info setObject:bundle_type() forKey:@"type"];                              /// App类型
        [info setObject:@(error.code) forKey:@"code"];
        [info setObject:error.description forKey:@"msg"];
        
        [parmas setObject:info forKey:@"data"];
        /// 回传给H5
        [self callJSWithMethod:@"xyqbNativeEvent" callWithArguments:@[parmas]];
    }
}

/// 回传信息给JS
/// @param model 识别的结果
/// @param isShootPagePortrait 正反面
- (void)callBackToJSWithModel:(WBIDCardInfoModel *)model isShootPagePortrait:(BOOL)isShootPagePortrait
{
    NSMutableDictionary *parmas = [NSMutableDictionary dictionary];
    [parmas setObject:@"faceIDIDCardCallBack" forKey:@"event"];                  /// 事件名
    /// 内部公共信息
    NSMutableDictionary *info = [NSMutableDictionary dictionary];
    [info setObject:@(isShootPagePortrait) forKey:@"isShootPagePortrait"];       /// 人像面
    [info setObject:model.orderNo ? model.orderNo :@"" forKey:@"orderNo"];       /// 本次识别的订单号
    [info setObject:bundle_type() forKey:@"type"];                              /// App类型
    [info setObject:@(0) forKey:@"code"];
    
    if (isShootPagePortrait) {
        [info setObject:model.idcard ? model.idcard :@"" forKey:@"idNo"];       /// 身份证号
        [info setObject:model.name ? model.name :@"" forKey:@"name"];           /// 名字
        [info setObject:model.nation ? model.nation :@"" forKey:@"nation"];     /// 民族
        [info setObject:model.birth ? model.birth:@"" forKey:@"birth"];         /// 出生日期
        [info setObject:model.sex ? model.sex :@"" forKey:@"sex"];              /// 性别
        [info setObject:model.address ? model.address :@"" forKey:@"address"];  /// 住址
        if (model.frontFullImg) {                                               /// 人像面图片
            NSData *imageData = UIImageJPEGRepresentation(model.frontFullImg, 0.8f);
            NSString *imageStr = [imageData base64EncodedStringWithOptions:0];
            [info setObject:imageStr forKey:@"base64Str"];
        }
    }else{
        [info setObject:model.authority ? model.authority :@"" forKey:@"authority"];  /// 签发机关
        [info setObject:model.validDate ? model.validDate :@"" forKey:@"validDate"];  /// 有效日期
        if (model.backFullImg) {                                                      /// 国徽面图片
            NSData *imageData = UIImageJPEGRepresentation(model.backFullImg, 0.8f);
            NSString *imageStr = [imageData base64EncodedStringWithOptions:0];
            [info setObject:imageStr forKey:@"base64Str"];
        }
    }
     [parmas setObject:info forKey:@"data"];
    /// 回传给H5
    [self callJSWithMethod:@"xyqbNativeEvent" callWithArguments:@[parmas]];
}


// OCR统计信息
/// @param side 正反面
/// @param desc 事件描述
- (void)ocrEventAnalyticsWithSide:(BOOL)side desc:(NSString *)desc
{
    NSDictionary *propertieDic =@{@"event_uuid":[QGUserInfo sharedUserInfo].uuid,
                                  @"event_side":@(side),
                                  @"event_desc":desc};
      [self ocrAnalyticsTrackWithDeatilInfo:propertieDic];
}
/**
 face++ Ocr数据埋点统计
 
 @param info 统计信息
 */
-(void)ocrAnalyticsTrackWithDeatilInfo:(NSDictionary *)info{
    
    [QGAnalyticsService analyticsTrack:@"TXSDK_AppOCR_Event" withProperties: info];
}


@end
