//
//  QGBaseTableViewController.h
//  CreditWallet
//
//  Created by 张博 on 16/10/21.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "QGBaseViewController.h"
@interface QGBaseTableViewController : QGBaseViewController <UITableViewDelegate, UITableViewDataSource>

/**
 列表控件的原始frame
 */
@property (nonatomic, assign, readonly) CGRect originRect;

/**
 默认提供的tableView
 */
@property (nonatomic, strong, null_resettable) UITableView *tableView;

/**
 默认为 UITableViewStylePlain
 */
@property (nonatomic, assign) UITableViewStyle tableViewStyle;

/**
 是否放在导航栏下面 
 */
@property (nonatomic, assign) BOOL isBelowNavBar;

/**
 是否放在tabbar的上面
 [[UITabBar appearance] setTranslucent:NO]的时候不需要此方法
 */
@property (nonatomic, assign) BOOL isAboveTabBar;

/// 距离底部的高度
@property (nonatomic, assign) CGFloat distanceBottom;

/**
 显示键盘
 */
- (void)keyboardWillShow:(NSNotification *_Nonnull)notification;

/**
 隐藏键盘
 */
- (void)keyboardWillHidden:(NSNotification *_Nonnull)notification;
@end
