//
//  QGAppBusinessStateEvent.h
//  VirtualPayment
//
//  Created by silicn on 2019/7/10.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGAnalyticsService.h"

NS_ASSUME_NONNULL_BEGIN


/**
  业务状态变更类型事件
 */
@interface QGAppBusinessStateEvent : QGAppAnalyticsEvent

///页面名称，eg:我的-设置
@property (nonatomic, copy) NSString *abse_page_name ;
///事件名称，eg:修改交易密码
@property (nonatomic, copy) NSString *abse_action_name ;
///事件状态值，可选值：success代表事件成功，failed代表事件失败，可拓展为其它不重复状态值，eg:success
@property (nonatomic, copy) NSString *abse_state_value ;
/// 失败码
@property (nonatomic, copy) NSString * abse_state_code;
/// 失败原因
@property (nonatomic, copy) NSString * abse_state_desc;
/// 失败者的手机号
@property (nonatomic, copy) NSString * abse_state_phone;

/**
 业务状态变更类型事件
 全量初始化方法
 
 特别注意：
 NSString类型的参数nil表示不包含这个字段
 
 @param  page_name   页面名称
 @param  action_name 事件名称
 @param  state_value 事件状态值   可选值：success代表事件成功，failed代表事件失败
 @return ABSEEvent
 */
+ (instancetype)abseEventWithPage:(nullable NSString *)page_name
                           action:(nullable NSString *)action_name
                            state:(nullable NSString *)state_value;


/// 业务状态变更类型事件  全量初始化方法 (NSString类型的参数nil表示不包含这个字段)
/// @param page_name 页面名称
/// @param action_name 事件名称
/// @param state_value 事件状态值   可选值：success代表事件成功，failed代表事件失败
/// @param state_code 业务失败时状态码
/// @param state_phone 手机号
/// @param state_desc 失败原因描述
+ (instancetype)abseEventWithPage:(nullable NSString *)page_name
                           action:(nullable NSString *)action_name
                            value:(nullable NSString *)state_value
                             code:(nullable NSString *)state_code
                             desc:(nullable NSString *)state_desc
                            phone:(nullable NSString *)state_phone;
                            

@end

NS_ASSUME_NONNULL_END
