//
//  Mediator.m
//  CreditWallet
//
//  Created by 金修博 on 17/4/18.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "Mediator.h"
#import "QGBaseViewController.h"
#import "SystemManager.h"
#import "UIViewController+WidgetCallBack.h"
#import <UIKit/UIKit.h>
#import <objc/runtime.h>

@implementation Mediator

/**
 中间件:本地访问入口
 
 @param targetName 类名
 @param param 传参
 @param handlerBlock 回调
 */
+ (void)performTarget:(NSString *)targetName parameters:(NSDictionary *)param handlerBlock:(void (^)(NSString *tag, NSDictionary *parameters))handlerBlock {
    [self performTarget:targetName isPush:YES parameters:param handlerBlock:handlerBlock];
}


/**
 中间件:原生访问入口
 
 @param targetName 类名
 @param isPush YES push NO present
 @param param 传参
 @param handlerBlock 回调
 */
+ (void)performTarget:(NSString *)targetName isPush:(BOOL)isPush parameters:(NSDictionary *)param handlerBlock:(void (^)(NSString *tag, NSDictionary *parameters))handlerBlock
{
    [self performTarget:targetName isPush:isPush animation:YES parameters:param handlerBlock:handlerBlock];
}


/**
 中间件:原生访问入口
 
 @param targetName 类名
 @param param 传参
 @param isPush YES push NO present
 @param animation 是否需要动画
 @param handlerBlock 回调
 */
+ (void)performTarget:(NSString *)targetName isPush:(BOOL)isPush animation:(BOOL)animation parameters:(NSDictionary *)param handlerBlock:(void (^)(NSString *tag, NSDictionary *parameters))handlerBlock {
    if (!targetName || [targetName isEqualToString:@""]) {
        return;
    }
    //目标类
    Class targetClass = NSClassFromString(targetName);
    QGBaseViewController *targetVC = [[targetClass alloc] init];
    //如果不是继承基类 则默认不处理
    if (![targetVC isKindOfClass:[QGBaseViewController class]]) {
        NSLog(@"没有继承基类");
        return;
    }
    //检查入参
    BOOL checkResult = [targetVC checkParameters:param];
    if (!checkResult) {
        NSLog(@"入参错误");
        return;
    }
    //传参
    [targetVC transferParameters:param];
    //设置控制器的回调block
    if (handlerBlock) {
        targetVC.callBackBlock = handlerBlock;
    }
    
    if (isPush) {
        if ([SystemManager shareInstance].currentNav) {
            //push
            [[SystemManager shareInstance].currentNav pushViewController:targetVC animated:animation];
        }
        else
        {
            NSLog(@"导航控制器不存在");
        }
    }
    else
    {
        //present 会默认加上导航
        UINavigationController * navController = [[UINavigationController alloc]initWithRootViewController:targetVC];
        [[SystemManager shareInstance].currentViewController presentViewController:navController animated:animation completion:nil];
    }
    
    
}

@end
