//
//  Mediator.h
//  CreditWallet
//
//  Created by 金修博 on 17/4/18.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 用于内部跳转
 */
@interface Mediator : NSObject

/**
 中间件:原生访问入口 默认方法
 
 @param targetName 类名
 @param param 传参
 @param handlerBlock 回调
 */
+ (void)performTarget:(NSString *)targetName parameters:(NSDictionary *)param handlerBlock:(void (^)(NSString *tag, NSDictionary *parameters))handlerBlock;

/**
 中间件:原生访问入口 非push时调用
 
 @param targetName 类名
 @param isPush YES push NO present（会默认加上导航）
 @param param 传参
 @param handlerBlock 回调
 */
+ (void)performTarget:(NSString *)targetName isPush:(BOOL)isPush parameters:(NSDictionary *)param handlerBlock:(void (^)(NSString *tag, NSDictionary *parameters))handlerBlock;

/**
 中间件:原生访问入口
 
 @param targetName 类名
 @param param 传参
 @param isPush YES push NO present
 @param animation 是否需要动画
 @param handlerBlock 回调
 */
+ (void)performTarget:(NSString *)targetName isPush:(BOOL)isPush animation:(BOOL)animation parameters:(NSDictionary *)param handlerBlock:(void (^)(NSString *tag, NSDictionary *parameters))handlerBlock;

@end
