//
//  QGCalendarManager.h
//  CreditWallet
//
//  Created by 张博 on 16/10/19.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "QGCalendarMonthModel.h"
#import "QGBrokenLineMonthModel.h"
@interface QGCalendarManager : NSObject


+ (instancetype)shareInstance;

/**
 *  截止时长  显示多少天
 */
@property (nonatomic, assign) NSInteger timeLength;

/**
 *  抢票的天数  抢票天数 >= 截止时间
 */
@property (nonatomic, assign) NSInteger robTicketLength;


/// 获取折线图所传日期当月的数据
/// @param date 传输的月份信息
/// @param today 今天的日期
- (QGBrokenLineMonthModel *)getBrokenLineMonthDataSourceWithDate:(NSDate *)date today:(NSDate *)today;

/**
 *  获取火车票所传日期的当月数据
 *
 *  @param date 传参
 */
- (QGCalendarMonthModel *)getTrainMonthDataSourceWithData:(NSDate *)date;

/**
 *  获取传入日期的下个月的时间  传入2016-10-11 得到 2016-11-11
 *
 *  @param date 参考日期
 *
 *  @return 参考日期的下个月日期
 */
- (NSDate *)nextMonthDateWithDate:(NSDate *)date;

/**
 *  比较两个时间是否是同一个月
 *  @return 比较结果
 */
- (BOOL)date:(NSDate *)theDate isEqualMonthAnother:(NSDate *)anotherDate;

/**
 *  获取格式为 yyyyMMdd的string时间
 */
- (NSString *)getStringFromDate:(NSDate *)date;

/**
 *  根据字符串 和 formatter格式获取NSDate
 *
 *  @param dateStr   时间字符串
 *  @param formatter 时间格式
 *
 *  @return date
 */
- (NSDate *)getDateFromString:(NSString *)dateStr formatter:(NSString *)formatter;


/**
 *  根据时间戳 和 formatter日期格式获取字符串
 *
 *  @param dateStr   时间戳
 *  @param formatter 日期格式
 *
 *  @return 字符串
 */
- (NSString *)getDateStrFromSince1970:(NSString *)dateStr formatter:(NSString *)formatter;



/**
 *  根据日期 和 formatter日期格式获取字符串
 *
 *  @param date      日期
 *  @param formatter 日期格式
 *
 *  @return 字符串
 */
- (NSString *)getStringFromDate:(NSDate *)date formatter:(NSString *)formatter;

/**
 *  获取从fromTime 一段时间后的日期
 *
 *  @return 日期
 */
- (NSDate *)getSomeTimeLaterFromTime:(NSDate *)fromTime timeInterval:(NSTimeInterval)secsToBeAdded;


/**
 *  获取 dateStr 的 someTime 前的时间
 *
 *  @param dateStr   指定时间字符串
 *  @param formatter 时间格式
 *
 *  @return 返回结果时间
 */
- (NSDate *)getSomeTimeAgoFromDateStr:(NSString *)dateStr timeInterval:(NSTimeInterval)someTime formatter:(NSString *)formatter;


/**
 *  获取开始时间到结束时间的日期数组 (火车票抢票时间选择使用)
 *  日期格式 ：MM：dd
 *  时间格式 ：HH：00
 *  @param fromDate 开始时间
 *  @param toDate   结束时间
 *
 *  @return 结果数组
 */
- (NSArray *)getDateArrayFromDate:(NSDate *)fromDate toDate:(NSDate *)toDate;


/// 获取从开始日期到结束日期之间的年和月
/// 格式如下：
/// 2030 = (01,02,03,04,05,06);
/// 取值范围 大于等于开始日期，小于结束日期（月）
/// @param fromDate 开始日期
/// @param toDate 结束日期
- (NSDictionary *)getYearsAndMonthsFromDate:(NSDate *)fromDate toDate:(NSDate *)toDate;

/**
 *  获取今天的日期
 *
 *  @return  今天的日期
 */
- (NSDate *)getToday;

/**
 *  获取截止日期
 *
 *  @return 截止日期
 */
- (NSDate *)getEndDate;

/**
 *  抢票截止日期
 *
 *  @return 截止日期
 */
- (NSDate *)getRobTicketEndDate;

/*
 * 根据时间戳转换成时间字符串
 * param1:NSInteger类型的时间戳  param2:要转换成的字符串类型,如:yyyy-MM-dd HH:mm:ss
 *
 * @return 字符串类型的时间
 */
- (NSString *)getDateStringWithTimestamp:(NSInteger)timestamp andFormatter:(NSString *)format;


/*
 * 根据时间戳转换成时间字符串 上面那个时间戳转换方法在iOS8上有问题
 * param1:NSString类型的时间戳
 *
 * @return 字符串类型的时间
 */
- (NSString *)getDateStingFromTimestamp:(NSString *)timeStampString withFormatter:(NSString *)format;
- (NSString *)getDateStingFromOriginTimestamp:(NSString *)timeStampString withFormatter:(NSString *)format;

/*
 * 根据时间戳转换成时间字符串
 * param1:NSInteger类型的时间戳  param2:要转换成的字符串类型,如:yyyy-MM-dd HH:mm:ss
 *
 * @return NSDate类型的时间
 */
- (NSDate *)getDateWithTimestamp:(NSInteger)timestamp andFormatter:(NSString *)format;


/**
 把2016-6-6 转成 6月6日

 @param dateStr 日期  如2016-6-6
 @return 格式化后的字符串
 */
- (NSString *)formatDateWithDateString:(NSString *)dateStr;


/**
 根据数字具体返回是一周周几  0位周日
 */
- (NSString *)formatWeek:(NSNumber *)week;

/**
 根据时间戳转换成时间字符串

 @param timestamp 标准时间戳（取的是秒）
 @param format 格式化字符串
 @return 格式化后的字符串
 */
- (NSString *)getDateStringWithSecondTimestamp:(NSInteger)timestamp andFormatter:(NSString *)format;

@end
