//
//  QGScreenshotsFeedbackView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/12/26.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGScreenshotsFeedbackView.h"

#import "QGBasicUITool.h"
#import "SystemManager.h"
#import "QGThirdPlatformService.h"

//View
#import "QGShareView.h"
@interface QGScreenshotsFeedbackView ()

/// 截屏图片
@property (nonatomic, strong) UIImageView * screenshotsImgView;

@end


@implementation QGScreenshotsFeedbackView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //背景层点击事件
        UIButton * bgButton = [UIButton creatButtonWithSuperView:self title:nil titleFont:nil textColor:nil];
        [bgButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.mas_equalTo(self);
        }];
        
        //手动取消逻辑
        @weakify(self);
        [bgButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self dismiss];
        }];
        
        
        //分享、客服展示区域
        UIView * feedbackView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor clearColor]];
        [feedbackView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(88, 143));
            make.right.offset(0);
            make.centerY.mas_equalTo(self);
        }];
        
        //分享灰色背景
        UIButton * shareGrayView = [UIButton creatButtonWithSuperView:feedbackView title:nil titleFont:nil textColor:nil];
        shareGrayView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.7];
        shareGrayView.layer.cornerRadius = 6;
        shareGrayView.clipsToBounds = YES;
        [shareGrayView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.right.inset(0);
            make.height.mas_equalTo(106);
        }];
        //分享点击事件
        [shareGrayView touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self shareButtonClick];
        }];
        
        //图片
        self.screenshotsImgView = [UIImageView creatImageViewWithSuperView:shareGrayView imageName:nil];
        self.screenshotsImgView.clipsToBounds = YES;
        self.screenshotsImgView.contentMode = UIViewContentModeScaleAspectFill;
        [self.screenshotsImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.inset(8);
            make.height.mas_equalTo(72);
        }];
        
        //分享图标
        UIImageView * shareImgView = [UIImageView creatImageViewWithSuperView:shareGrayView imageName:@"screenshots_share"];
        [shareImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(8);
            make.bottom.inset(7);
            make.size.mas_equalTo(CGSizeMake(13, 13));
        }];
        
        //好友分享
        UILabel * shareLabel = [UILabel creatLabelWithSuperView:shareGrayView title:@"好友分享" titleFontSize:[UIFont qg_lightFontOfSize:13] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [shareLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(shareImgView.mas_right).offset(8);
            make.centerY.mas_equalTo(shareImgView);
        }];
        
        //在线客服灰色背景
        UIButton * serviceGrayView = [UIButton creatButtonWithSuperView:feedbackView title:nil titleFont:nil textColor:nil];
        serviceGrayView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.7];
        serviceGrayView.layer.cornerRadius = 6;
        serviceGrayView.clipsToBounds = YES;
        [serviceGrayView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.inset(0);
            make.height.mas_equalTo(29);
        }];
        
        //客服反馈点击事件
        [serviceGrayView touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self serviceButtonClick];
        }];
        
        
        //客服图标
        UIImageView * serviceImgView = [UIImageView creatImageViewWithSuperView:serviceGrayView imageName:@"screenshots_service"];
        [serviceImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(8);
            make.centerY.offset(0);
            make.size.mas_equalTo(CGSizeMake(14, 13));
        }];
        
        //在线客服
        UILabel * serviceLabel = [UILabel creatLabelWithSuperView:serviceGrayView title:@"在线客服" titleFontSize:[UIFont qg_lightFontOfSize:13] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [serviceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(serviceImgView.mas_right).offset(8);
            make.centerY.mas_equalTo(serviceImgView);
        }];
        
    }
    return self;
}


/// 展示
- (void)showWithImage:(UIImage *)image
{
    self.screenshotsImgView.image = image;
    
    //添加在window上
    [[SystemManager getKeyWindow] addSubview:self];
    [self mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.offset(0);
    }];
    
    //5S后自动取消
    [self performSelector:@selector(dismiss) withObject:nil afterDelay:5];
}

/// 隐藏
- (void)dismiss
{
    [self removeFromSuperview];
}

#pragma mark - Action
- (void)shareButtonClick
{
    [self dismiss];
    
    if (self.screenshotsImgView.image) {
     //分享
       QGShareModel * shareModel = [[QGShareModel alloc] init];
       shareModel.image = self.screenshotsImgView.image;
        shareModel.shareObjType = QGShareModelObjTypeImage;
       QGShareView * shareView = [[QGShareView alloc] initWithItems:nil shareModel:shareModel];
       [shareView showInView:nil];
    }
}

- (void)serviceButtonClick
{
    [self dismiss];
    if (self.serviceButtonClickBlock) {
        self.serviceButtonClickBlock();
    }
}

- (void)dealloc
{
    NSLog(@"_______");
}



@end
