//
//  QGTableViewCommonCell.h
//  VirtualPayment
//
//  Created by 胡红磊 on 2019/6/19.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface QGTableViewCommonCell : UITableViewCell

/**
 底部分割线距离两边的宽度 默认是20
 */
@property (nonatomic, assign)CGFloat padding;

/**
 右侧图片是否显示 默认是显示
 */
@property (nonatomic, assign)BOOL arrowHide;

/**
 底部分割线是否显示 默认是显示
 */
@property (nonatomic, assign)BOOL separateLineHide;

/**
 右侧图标
 */
@property (nonatomic, strong, readonly) UIImageView *arrowImage;


/**
 子类实现这个方法

 @param tableView UITableView
 @return cell
 */
+ (instancetype)initWithTableView:(UITableView *)tableView;


@end

NS_ASSUME_NONNULL_END
