//
//  QGCustomPageControl.h
//  VirtualPayment
//
//  Created by silicn on 2019/11/22.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface QGCustomPageControl : UIView

/// 一个有多少个page页, 默认是0
@property(nonatomic) NSInteger numberOfPages;          // default is 0

///当前page页,默认是0
@property(nonatomic) NSInteger currentPage;

 /// 如果只有一个则隐藏
@property(nonatomic) BOOL hidesForSinglePage;

/// 圆点颜色 默认颜色lightGray
@property(nullable, nonatomic,strong) UIColor *pageIndicatorTintColor;

/// 当前选中圆点颜色,一般来说与其他圆点不同 默认颜色whiteColor
@property(nullable, nonatomic,strong) UIColor *currentPageIndicatorTintColor;

/// 圆点间的间距大小
@property (nonatomic, assign)CGFloat indictorSpace;

///圆点大小,
@property (nonatomic, assign)CGSize indictorSize;

/// 注意,如果设置了pageImageName
/// 则pageIndicatorTintColor和currentPageIndicatorTintColor就会失效
/// 默认背景图片
@property (nonatomic, copy) NSString *pageImageName;

///选中状态下的图片
@property (nonatomic, copy) NSString *currentPageImageName;

@end

NS_ASSUME_NONNULL_END
