//
//  QGMarqueeView.m
//  VirtualPayment
//
//  Created by silicn on 2019/5/20.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGMarqueeView.h"
#import "QGBasicUITool.h"
#define kDisplayLinkTimes 1


@interface QGMarqueeCell : UICollectionViewCell

@property (nonatomic, strong)UILabel *textLab;

/// 字体颜色
@property (nonatomic, strong)UIColor *textColor;

///字体Font Default SystemFontSize:15.0f
@property (nonatomic, strong)UIFont *font;


@end

@implementation QGMarqueeCell


- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor clearColor];
        self.contentView.backgroundColor = [UIColor clearColor];
        self.textLab = [UILabel creatLabelWithSuperView:self.contentView
                                                  title:nil
                                          titleFontSize:self.font ? self.font :[UIFont qg_regularFontOfSize:13]
                                              textColor:self.textColor ? self.textColor :[UIColor textColor3333]
                                              alignment:NSTextAlignmentLeft];
        self.textLab.numberOfLines = 1;
        [self.textLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self.contentView);
        }];
    }
    return self;
}

- (void)setTextColor:(UIColor *)textColor
{
    if (_textColor != textColor) {
        _textColor = textColor;
        _textLab.textColor = textColor;
    }
}

- (void)setFont:(UIFont *)font
{
    if (_font != font) {
        _font = font;
        _textLab.font = font;
    }
}

@end

@interface QGMarqueeView ()<UICollectionViewDelegate,UICollectionViewDataSource>

@property (nonatomic, strong)UIImageView *imageView;

@property (nonatomic, strong)UIView *textContentView;

@property (nonatomic, strong)UIButton *accessoryButton;

@property (nonatomic, strong)CADisplayLink *displayLink;

@property (nonatomic, assign)NSInteger time;

@property (nonatomic, strong)NSMutableArray *dataSource;

@property (nonatomic, assign)NSInteger currentIndex;

@property (nonatomic, strong)UICollectionView *collectioniView;


@end


@implementation QGMarqueeView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.font = [UIFont qg_regularFontOfSize:13];
        self.textColor = [UIColor textColor3333];
        self.dataSource = [NSMutableArray array];
        [self initCustomUI];
    }
    return self;
}


- (void)initCustomUI
{
    //小喇叭
    self.imageView = [UIImageView creatImageViewWithSuperView:self imageName:@"micro_notice"];
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self).offset(0);
        make.centerY.equalTo(self.mas_centerY);
        make.width.mas_equalTo(21);
        make.height.mas_equalTo(20);
    }];
    
    //查看更多
    self.accessoryButton = [UIButton creatButtonWithSuperView:self title:nil titleFont:nil textColor:nil];
    [self.accessoryButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self).offset(0);
        make.centerY.equalTo(self.mas_centerY);
        make.width.equalTo(@(5));
        make.height.equalTo(@(9));
    }];
    [self.accessoryButton setImage:[UIImage imageNamed:@"notice_Indicator"] forState:UIControlStateNormal];
    
    //文字内容区域
    self.textContentView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor clearColor]];
    self.textContentView.clipsToBounds = YES;
    [self.textContentView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.imageView.mas_right).offset(10);
        make.right.equalTo(self.accessoryButton.mas_left).inset(12);
        make.top.equalTo(self).inset(2);
        make.bottom.equalTo(self).inset(2);
    }];
    
    /// 设置文字滚动collectionView
    UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc]init];
    layout.minimumLineSpacing = 0;
    layout.minimumInteritemSpacing = 0;
    layout.scrollDirection = UICollectionViewScrollDirectionVertical;
    
    self.collectioniView = [[UICollectionView alloc]initWithFrame:CGRectZero collectionViewLayout:layout];
    self.collectioniView.dataSource = self;
    self.collectioniView.delegate = self;
    [self.textContentView addSubview:self.collectioniView];
    self.collectioniView.backgroundColor = [UIColor clearColor];
    self.collectioniView.pagingEnabled = YES;
    self.collectioniView.scrollEnabled = NO;
    
    [self.collectioniView registerClass:[QGMarqueeCell class] forCellWithReuseIdentifier:@"collectionCell"];
    
    [self.collectioniView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.textContentView);
    }];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationDidEnterBackground) name:UIApplicationDidEnterBackgroundNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationWillEnterForeground) name:UIApplicationWillEnterForegroundNotification object:nil];
    
}

- (void)applicationDidEnterBackground
{
    [self destoryMarquee];
}

- (void)applicationWillEnterForeground
{
    if (self.textArray.count <= 1) return;
    
    [self beginMarquee];
}

#pragma mark - CollectionView Delegate

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.dataSource.count;
}

// The cell that is returned must be retrieved from a call to -dequeueReusableCellWithReuseIdentifier:forIndexPath:
- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGMarqueeCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"collectionCell" forIndexPath:indexPath];
    cell.textColor = self.textColor;
    cell.font = self.font;
    cell.textLab.text = self.dataSource[indexPath.row];
    return cell;
}


- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    [collectionView deselectItemAtIndexPath:indexPath animated:YES];
    if (self.clickEventBlock) {
        self.clickEventBlock(_currentIndex);
    }
}


#pragma mark --UICollectionViewDelegateFlowLayout
//定义每个Item 的大小
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return CGSizeMake(self.collectioniView.width, self.collectioniView.height);
}

//定义每个UICollectionView 的 margin
-(UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout insetForSectionAtIndex:(NSInteger)section
{
    return UIEdgeInsetsMake(0, 0, 0, 0);
}

- (void)scrollViewDidEndScrollingAnimation:(UIScrollView *)scrollView
{
    [self setContentOffsetRestoration];
}

/// 复位ScrollView的contentoffset,同时切换datasource
- (void)setContentOffsetRestoration
{
    if (_currentIndex >= _textArray.count - 1) { /// 如果滑动之前是最后一个在显示,则滑动之后当前是第一个
        _currentIndex = 0;
    }else{
        _currentIndex += 1;
    }
    
    /// 设置下一个值
    if (_currentIndex + 1 >= _textArray.count) {  /// 如果是最后一个,就重新取第一个值
        [self.dataSource addObject:_textArray[0]];
    }else{  /// 取下一个值
        [self.dataSource addObject:_textArray[_currentIndex + 1]];
    }
    
    /// 删除第一个值,保证dataSource仅包含三个值,上一个-当前-下一个
    [self.dataSource removeObjectAtIndex:0];
    
    [self.collectioniView reloadData];
    /// 复位collectionView的位置,保证是中间位置,可以上下滑动
    [self.collectioniView setContentOffset:CGPointMake(0, self.collectioniView.frame.size.height) animated:NO];
    
    
}




/**
 获取文字的宽度

 @param text NSString 内容文字
 @return CGFloat 单行文字的宽度
 */
- (CGFloat)getTextWidth:(NSString *)text
{
    if (text.length == 0) {
        return 0.0;
    }
    CGSize size = [text boundingRectWithSize:CGSizeMake(MAXFLOAT, self.font.lineHeight + 2) options: NSStringDrawingUsesLineFragmentOrigin attributes:@{NSFontAttributeName:self.font} context:nil].size;
    return size.width;
}

- (void)setTextArray:(NSArray<NSString *> *)textArray
{
    if (_textArray != textArray) {
        _textArray = textArray;
        [self.dataSource removeAllObjects];
        [self destoryMarquee];
        if (textArray.count == 0) return;
        self.currentIndex = 0;
        if (textArray.count == 1) {
            [self.dataSource addObject:[textArray firstObject]];
            [self.collectioniView reloadData];
        }else{
            [self.dataSource addObject:[textArray lastObject]];
            [self.dataSource addObject:[textArray firstObject]];
            [self.dataSource addObject:[textArray objectAtIndex:1]];
            [self.collectioniView reloadData];
            [self performSelector:@selector(scrollToMiddle) withObject:nil afterDelay:0.1];
        }
    }
}

- (void)setHiddenIndicator:(BOOL)hiddenIndicator
{
    _hiddenIndicator = hiddenIndicator;
    if (hiddenIndicator) {
        self.accessoryButton.hidden = YES;
        [self.textContentView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.imageView.mas_right).offset(10);
            make.right.equalTo(self).inset(12);
            make.top.equalTo(self).inset(2);
            make.bottom.equalTo(self).inset(2);
        }];
        
    }else{
        self.accessoryButton.hidden = NO;
        [self.textContentView mas_remakeConstraints:^(MASConstraintMaker *make) {
               make.left.equalTo(self.imageView.mas_right).offset(10);
               make.right.equalTo(self.accessoryButton.mas_left).inset(12);
               make.top.equalTo(self).inset(2);
               make.bottom.equalTo(self).inset(2);
           }];
    }
}

/// 初始化scrollView的位置
- (void)scrollToMiddle
{
    [self.collectioniView setContentOffset:CGPointMake(0, self.collectioniView.frame.size.height) animated:NO];
    [self beginMarquee];
}

#pragma mark — 计时器 滚动设置


- (void)displayLinkTime:(CADisplayLink *)displayLink
{
    self.time++;
    if (self.time == 5 * 60/kDisplayLinkTimes) { // 5秒之后重置文字的位置
        [self changeLabelSource];
        self.time = 0;
    }
}

- (void)changeLabelSource
{
    if (self.scrollDirection == QGMarqueeScrollDirectionBTT) {
        /// 自下而上
           [self.collectioniView setContentOffset:CGPointMake(0, self.collectioniView.frame.size.height * 2) animated:YES];
    }else if (self.scrollDirection == QGMarqueeScrollDirectionTTB){
        /// 自上而下
        [self.collectioniView setContentOffset:CGPointMake(0, 0) animated:YES];
    }
}

/**
 文字开始滚动，跑马灯开始
 */
- (void)beginMarquee
{
    self.time = 0;
    [self.displayLink addToRunLoop:[NSRunLoop currentRunLoop] forMode:NSRunLoopCommonModes];
    self.displayLink.paused = NO;
}

- (void)willMoveToSuperview:(UIView *)newSuperview
{
    [super willMoveToSuperview:newSuperview];
    if (self.superview) {
        [self destoryMarquee];
    }
}

- (void)destoryMarquee
{
    if (self.displayLink) {
        [NSObject cancelPreviousPerformRequestsWithTarget:self];
        [self.displayLink invalidate];
        self.displayLink = nil;
    }
}

- (CADisplayLink *)displayLink
{
    if (!_displayLink) {
        _displayLink = [CADisplayLink displayLinkWithTarget:self selector:@selector(displayLinkTime:)];
        _displayLink.frameInterval = kDisplayLinkTimes;
    }
    return _displayLink;
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    NSLog(@"QGMarquee Dealloc");
}



/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
