//
//  QGInputGroupView.h
//  VirtualPayment
//
//  Created by silicn on 2019/6/14.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,InputViewType){
    InputViewTypePwd,  //密码样式
    InputViewTypeText, //输入框样式
    InputViewTypeTextHint, // 输入样式带尾随提示
    InputViewTypeCustom    // 自定义样式
};

typedef void(^QGInputViewAccessoryBlock)();

@interface QGInputGroupView : UIView
///输入视图的类型
@property (nonatomic, assign)InputViewType type;
///标题或者提示
@property (nonatomic, copy)NSString *title;
///标题颜色
@property (nonatomic, strong)UIColor *titleColor;
///输入框
@property (nonatomic, strong, readonly)UITextField *textField;
///右边Button配件
@property (nonatomic, strong)UIButton *accessoryButton;

///自定义右视图，虚自定义width，height 默认和textField一样高度，可以修改
@property (nonatomic, strong)UIView *accessoryView;
/// accessoryButton类型时 点击事件
@property (nonatomic, copy)QGInputViewAccessoryBlock accessoryBlock;

/**
初始化方法

 @param  type       InputViewType
 @param  title      小标题: nil~无标题
 @param  placholder 候选提示语
 @return QGInputGroupView
 */
- (instancetype)initWithType:(InputViewType)type
                       title:(nullable NSString *)title
                 placeHolder:(NSString *)placholder;



@end

NS_ASSUME_NONNULL_END
