//
//  QGGradientShadowButton.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/10.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface QGGradientShadowButton : UIButton

/**
 渐变色图层
 */
@property (nonatomic, strong, readonly) CAGradientLayer * gradientLayer;

/**
 是否清除默认的圆角
 */
@property (nonatomic, assign) BOOL isClearCorner;

/**
 创建渐变色按钮

 @param title 标题
 @param superView 父视图
 @param textFont 字号
 @return 按钮实例
 */
+ (QGGradientShadowButton *)creatGradientColorButtonWithSuperView:(UIView *)superView title:(nullable NSString *)title textFont:(UIFont *)textFont;

/**
 设置按钮是否能点击

 @param isEnabled YES:能点击 NO:不能点击
 */
- (void)setGradientButtonIsClickEnabled:(BOOL)isEnabled;

@end

NS_ASSUME_NONNULL_END
