//
//  QGDesignatedCornerView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/8/8.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGDesignatedCornerView.h"

@interface QGDesignatedCornerView ()

/**
 圆角大小
 */
@property (nonatomic, assign) CGFloat radius;

/**
 圆角指定位置
 */
@property (nonatomic, assign) UIRectCorner corner;

/**
 圆角遮罩层
 */
@property (nonatomic, strong) CAShapeLayer *maskLayer;

@end


@implementation QGDesignatedCornerView


/**
 初始化方法

 @param radius 圆角大小
 @param corner 指定位置
 @return 实例化对象
 */
- (instancetype)initWithRadius:(CGFloat)radius corner:(UIRectCorner)corner
{
    if (self = [super init]) {
        self.radius = radius;
        self.corner = corner;
    }
    return self;
}

/**
 设置指定圆角大小
 @param radius 圆角尺寸
 @param corner 圆角位置
 */
- (void)setRadius:(CGFloat)radius corner:(UIRectCorner)corner {
    
    //iOS11以上用法
    if (@available(iOS 11.0, *)) {
        if (radius != self.layer.cornerRadius) {
            self.layer.cornerRadius = radius;
        }
        
        CACornerMask caCorner = (CACornerMask)corner;
        if (caCorner != self.layer.maskedCorners) {
            self.layer.maskedCorners = caCorner;
        }
        
    } else {
        
        if (!self.maskLayer) {
            self.maskLayer = [[CAShapeLayer alloc] init];
            self.layer.mask = self.maskLayer;
        }
        
        //不一样则重置路径
        UIBezierPath * path = [UIBezierPath bezierPathWithRoundedRect:self.bounds byRoundingCorners:corner cornerRadii:CGSizeMake(radius, radius)];
        if (!CGPathEqualToPath(path.CGPath, self.maskLayer.path)) {
            self.maskLayer.path = path.CGPath;
        }
        
        //不一样重置坐标系
        if (!CGRectEqualToRect(self.maskLayer.frame, self.bounds)) {
            self.maskLayer.frame = self.bounds;
        }
        
    }
}


- (void)layoutSubviews
{
    [super layoutSubviews];

    //设置圆角和角度 只有设置了圆角才会走这里
    if (self.radius > 0) {
        [self setRadius:self.radius corner:self.corner];
    }
}

@end
