//
//  QGBaseTabBar.m
//  QGScrollLabel
//
//  Created by silicn on 2019/5/8.
//  Copyright © 2019 Silicn. All rights reserved.
//

#import "QGCustomTabBar.h"
#import "SDWebImageDownloader.h"
#import "QGBasicUITool.h"

@interface QGTabBarItemModel ()


@end

@implementation QGTabBarItemModel

- (instancetype)initWithTitle:(nullable NSString *)title
           viewControllerName:(nullable NSString *)viewControllerName
                   nomalImage:(nullable UIImage *)nomalImage
                  selectImage:(nullable UIImage *)selectImage;
{
    self = [super init];
    if (self) {
        self.title = title;
        self.viewControllerName = viewControllerName;
        self.nomalImage = nomalImage;
        self.selectImage = selectImage;
    }
    return self;
}

@end



@interface QGCustomTabBar ()

@property (nonatomic, assign) UIEdgeInsets oldSafeAreaInsets;

@property (nonatomic, strong)NSMutableDictionary *badges;


@end

@implementation QGCustomTabBar


- (instancetype)initWithBarItems:(NSArray <QGTabBarItemModel *>*)barItems
{
    self = [super init];
    if (self) {
        self.oldSafeAreaInsets = UIEdgeInsetsZero;
        self.barItems = barItems;
      
        UIView *line = [[UIView alloc] initWithFrame:CGRectMake(0, -1.0/[UIScreen mainScreen].scale, [UIScreen mainScreen].bounds.size.width, 1.0/[UIScreen mainScreen].scale)];
        line.backgroundColor = [UIColor lineSeparatorColorDCDC];
        [self insertSubview:line atIndex:0];
    }
    return self;
}
- (void)updateTabBarItemWithModel:(QGTabBarItemModel *)model atIndex:(NSInteger)index
{
    if (index < 0 || index > self.barItems.count) return;
    NSMutableArray *itmes = [NSMutableArray arrayWithArray:self.barItems];
    [itmes replaceObjectAtIndex:index withObject:model];
    self.barItems = [itmes copy];
    [self setNeedsLayout];
}

- (void)setBarItems:(NSArray<QGTabBarItemModel *> *)barItems
{
    _barItems = barItems;
    [self setNeedsLayout];
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    
    for (int i = 0; i < self.items.count; i++) {
        UITabBarItem *item = self.items[i];
        item.titlePositionAdjustment = UIOffsetMake(0, -4);
        QGTabBarItemModel *model = self.barItems[i];
        if (model.nomalImage) {
            item.image = [model.nomalImage imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
        }
        if (model.selectImage) {
            item.selectedImage = [model.selectImage imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
        }else{
            item.selectedImage = item.image;
        }
        item.title = model.title;
        if (@available(iOS 10.0, *)) {
            item.badgeColor = self.badgeColor;
        } else {
            UIImage *image = [self circleImageWithColor:self.badgeColor];
            if ([item respondsToSelector:@selector(view)]) {
                 UIView *tabBarButton = [item performSelector:@selector(view)];
                [self customBadgeColorWith:image tabBarButton:tabBarButton];
            }
        }
        NSString *badge = [[self.badges objectForKey:[NSString stringWithFormat:@"%d",i]] stringValue];
        item.badgeValue = badge;
    }
}

- (void)customBadgeColorWith:(UIImage *)badgeImage tabBarButton:(UIView *)tabBarButton
{
    // iOS10以下的版本 角标其实是一张图片，所以我们一直找下去这个图片，然后替换他
    for(UIView *subview in tabBarButton.subviews) {
        NSString *classString = NSStringFromClass([subview class]);
        if ([classString rangeOfString:@"UIBadgeView"].location == NSNotFound) break;
        for(UIView *badgeSubview in subview.subviews) {
            NSString *badgeSubviewClassString = NSStringFromClass([badgeSubview class]);
            if ([badgeSubviewClassString rangeOfString:@"BadgeBackground"].location == NSNotFound) break;
                    [badgeSubview setValue:badgeImage forKey:@"image"];
        }
    }
}


- (void)setFont:(UIFont *)font
{
    _font = font;
    if (self.titleNomalColor) {
        [[UITabBarItem appearance] setTitleTextAttributes:@{NSFontAttributeName:font,NSForegroundColorAttributeName:self.titleNomalColor} forState:UIControlStateNormal];
    }else{
        [[UITabBarItem appearance] setTitleTextAttributes:@{NSFontAttributeName:font} forState:UIControlStateNormal];
    }
    if (self.titleHighlightColor) {
        [[UITabBarItem appearance] setTitleTextAttributes:@{NSForegroundColorAttributeName:self.titleHighlightColor} forState:UIControlStateSelected];
    }
    [self setNeedsDisplay];
}

- (void)setTitleNomalColor:(UIColor *)titleNomalColor
{
    _titleNomalColor = titleNomalColor;
    if (self.font) {
         [[UITabBarItem appearance] setTitleTextAttributes:@{NSForegroundColorAttributeName:titleNomalColor,NSFontAttributeName:self.font} forState:UIControlStateNormal];
    }else{
         [[UITabBarItem appearance] setTitleTextAttributes:@{NSForegroundColorAttributeName:titleNomalColor} forState:UIControlStateNormal];
    }
    [self setNeedsDisplay];
}

- (void)setTitleHighlightColor:(UIColor *)titleHighlightColor
{
    _titleHighlightColor = titleHighlightColor;
    if (self.font) {
        [[UITabBarItem appearance] setTitleTextAttributes:@{NSForegroundColorAttributeName:titleHighlightColor,NSFontAttributeName:self.font} forState:UIControlStateSelected];
    }else{
        [[UITabBarItem appearance] setTitleTextAttributes:@{NSForegroundColorAttributeName:titleHighlightColor} forState:UIControlStateSelected];
    }
    [self setNeedsDisplay];
}

- (void)badgeValue:(NSInteger)badge atIndex:(NSInteger)index
{
    if (index < 0) return;
    [self.badges setObject:@(badge) forKey:[NSString stringWithFormat:@"%ld",(long)index]];
}

- (void)removeAllBadgeValue
{
    [self.badges removeAllObjects];
}


#pragma mark — 网络更新TabBarItem


//- (void)requestTabBarItemsFormServer
//{
//    NSMutableArray *items = [NSMutableArray array];
//    
//    for (NSDictionary *dic in items) {
//        NSString *title = dic[@"text"];
//        NSString *nomalImageURL = dic[@"imgUrl"];
//        NSString *selectImageURL = dic[@"imgUrlActive"];
//        QGTabBarItemModel *model = [[QGTabBarItemModel alloc]init];
//        model.title = title;
//        model.nomalImageName = nomalImageURL;
//        model.selectImageName = selectImageURL;
//        
//        [items addObject:model];
//    }
//}
//
//- (void)updatetabBarItemWitURL:(NSString *)url  model:(QGTabBarItemModel *)model isNomal:(BOOL)isNomal
//{
//    SDWebImageDownloader *downLoad = [SDWebImageDownloader sharedDownloader];
//    
//    [downLoad downloadImageWithURL:[NSURL URLWithString:url] completed:^(UIImage * _Nullable image, NSData * _Nullable data, NSError * _Nullable error, BOOL finished) {
//        if (finished) {
//            UIImage *compactImage = [self compressImageWith:image];
//            
//        }
//    }];
//}

/** 
 压缩图片到指定尺寸
 */
- (UIImage *)compressImageWith:(UIImage *)image{
    CGFloat scale = [UIScreen mainScreen].scale;
    CGSize size = CGSizeMake(40 * scale, 40 * scale);
    UIGraphicsBeginImageContext(size);
    // Tell the old image to draw in this new context, with the desired
    // new size
    [image drawInRect:CGRectMake(0,0,size.width,size.height)];
    // Get the new image from the context
    UIImage* newImage = UIGraphicsGetImageFromCurrentImageContext();
    
    // End the context
    UIGraphicsEndImageContext();
    
    // Return the new image.
    return newImage;
}

/** 
 绘制一个圆形图片
 */
- (UIImage *)circleImageWithColor:(UIColor *)color
{
    CGFloat scale = [UIScreen mainScreen].scale;
    CGSize size = CGSizeMake(36*scale, 36*scale);
    // 开始图形上下文，NO代表透明
    UIGraphicsBeginImageContextWithOptions(size, NO, scale);
    // 获得图形上下文
    CGContextRef ctx = UIGraphicsGetCurrentContext();
    [color setFill];
    // 设置一个范围
    CGRect rect = CGRectMake(0, 0, size.width, size.height);
    CGContextFillEllipseInRect(ctx,rect);
    CGContextClip(ctx);
    // 从上下文上获取剪裁后的照片
    UIImage *newImage = UIGraphicsGetImageFromCurrentImageContext();
    // 关闭上下文
    UIGraphicsEndImageContext();
    return newImage;
}



#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        self.oldSafeAreaInsets = UIEdgeInsetsZero;
    }
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)aDecoder {
    if (self = [super initWithCoder:aDecoder]) {
        self.oldSafeAreaInsets = UIEdgeInsetsZero;
    }
    return self;
}

- (void)safeAreaInsetsDidChange {
    [super safeAreaInsetsDidChange];
    
    if (!UIEdgeInsetsEqualToEdgeInsets(self.oldSafeAreaInsets, self.safeAreaInsets)) {
        [self invalidateIntrinsicContentSize];
        
        if (self.superview) {
            [self.superview setNeedsLayout];
            [self.superview layoutSubviews];
        }
    }
}

- (CGSize)sizeThatFits:(CGSize)size {
    size = [super sizeThatFits:size];
    
    if (@available(iOS 11.0, *)) {
        float bottomInset = self.safeAreaInsets.bottom;
        if (bottomInset > 0 && size.height < 50 && (size.height + bottomInset < 90)) {
            size.height += bottomInset;
        }
        
    }
    
    
    return size;
}

- (void)setFrame:(CGRect)frame {
    if (self.superview) {
        if (frame.origin.y + frame.size.height != self.superview.frame.size.height) {
            frame.origin.y = self.superview.frame.size.height - frame.size.height;
        }
    }
    [super setFrame:frame];
}

- (NSMutableDictionary *)badges
{
    if (_badges == nil) {
        _badges = [NSMutableDictionary dictionary];
    }
    return _badges;
}



/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
