//
//  ZHAnimationBaseView.m
//  GoodTodayCustomer
//
//  Created by zhangbo on 16/4/7.
//  Copyright © 2016年 shiguanghui. All rights reserved.
//

#import "ZHAnimationBaseView.h"
#import "QGBasicUITool.h"
#import "UIView+Extend.h"
@interface ZHAnimationBaseView ()

/**
 阴影视图 动画时透明度为 .5
 */
@property (nonatomic, strong) UIControl * shadowView;

/**
 * 阴影视图下面的视图，透明度默认为0 当弹出动画时，需要在阴影底部做其他动画时使用
 */
@property (nonatomic, strong, readwrite) UIView * belowShadowView;


/**
 弹出动画需要适配底部安全区域时，会用到此视图
 */
@property (nonatomic, strong) UIView * sheetSafeBottomView;



@end


@implementation ZHAnimationBaseView



- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        [self initNormalUI];
    }
    return self;
}


- (instancetype)initWithCoder:(NSCoder *)aDecoder
{
    if (self = [super initWithCoder:aDecoder])
    {
        [self initNormalUI];
    }
    return self;
}

//初始化
- (void)initNormalUI
{
    self.shadowViewAnimationAlpha = .4f;
    
    self.belowShadowView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT)];
    self.belowShadowView.alpha = 0;
    
    //负责阴影
    self.shadowView = [[UIControl alloc]initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT)];
    self.shadowView.backgroundColor = [UIColor blackColor];
    self.shadowView.alpha = 0;
    [self.shadowView addTarget:self action:@selector(cancleButtonClick) forControlEvents:UIControlEventTouchUpInside];
}


- (void)cancleButtonClick
{
    if (self.isCancleClickBackground) {
        return;
    }
    [self dismissAnimation:YES dismissBlock:YES];
}

/**
 *  显示出来
 *
 *  @param animation 是否需要动画
 */
- (void)showAnimation:(BOOL)animation
{
    [self showWithView:nil animation:animation];
    
}

///显示出来到view上
- (void)showWithView:(UIView *)view animation:(BOOL)animation
{
    UIView * superView = view;
    
    if (!superView) {
        superView = [self getKeyWindow];
    }
    [superView addSubview:self.belowShadowView];
    [superView addSubview:self.shadowView];
    //需要适配安全区域，才会添加此视图
    if (self.isNeedSafeBottomMargin) {
        [superView addSubview:self.sheetSafeBottomView];
    }
    [superView addSubview:self];

    if (self.animationType == ZHAnimationTypeActionSheet) {
        [self addActionSheetAnimation:animation];
    }
    else if (self.animationType == ZHAnimationTypeAlert)
    {
        [self addAlertAnimation:animation];
    }
    
}


#pragma mark - 添加动画类型
//自定义UIActionSheetView 动画,自下向上弹出
- (void)addActionSheetAnimation:(BOOL)animated
{
    if (animated)
    {
        CGRect rect = self.frame;
        rect.origin.y = MAINSCREEN_HEIGHT;
        rect.origin.x = 0;
        self.frame = rect;
        //需要适配安全区域，才会添加此视图
        if (self.isNeedSafeBottomMargin) {
            self.sheetSafeBottomView.frame = CGRectMake(rect.origin.x, rect.origin.y, rect.size.width, rect.size.height + [DeviceAdaptation getBottomSafeAreaHeight]);
        }
        __weak typeof(self) weakSelf = self;
        [UIView animateWithDuration:KAniamtionDuration animations:^{
            weakSelf.shadowView.alpha = self.shadowViewAnimationAlpha;
            CGFloat animationY = MAINSCREEN_HEIGHT - weakSelf.frame.size.height;
            //底部有按钮
            if (weakSelf.isNeedSafeBottomMargin) {
                animationY -= [DeviceAdaptation getBottomSafeAreaHeight];
                weakSelf.sheetSafeBottomView.top = animationY;
            }
            weakSelf.top = animationY;
            
           
        } completion:^(BOOL finished) {
            
        }];
    }
    else
    {
        self.frame = CGRectMake(0, MAINSCREEN_HEIGHT - self.frame.size.height, self.frame.size.width, self.frame.size.height);
        self.shadowView.alpha = self.shadowViewAnimationAlpha;
    }
}

//自定义UIAlertView 弹出动画
- (void)addAlertAnimation:(BOOL)animation
{
    if (animation)
    {
        self.layer.transform = CATransform3DMakeScale(1.1f, 1.1f, 1.0f);
        self.alpha = 0.0f;
        __weak typeof(self) weakSelf = self;
        [UIView animateWithDuration:KAniamtionDuration animations:^{
            weakSelf.shadowView.alpha = self.shadowViewAnimationAlpha;
            weakSelf.layer.transform = CATransform3DIdentity;
            weakSelf.alpha = 1.0f;
        } completion:^(BOOL finished) {
            
        }];
    } else
    {
        self.alpha = 1;
        self.shadowView.alpha = self.shadowViewAnimationAlpha;
    }
}




/**
 *  隐藏
 *
 *  @param animation 是否需要动画
 */
- (void)dismissAnimation:(BOOL)animation dismissBlock:(BOOL)isBlock;
{
    if (animation)
    {
        switch (self.animationType)
        {
            case ZHAnimationTypeActionSheet:
            {
                [self cancelActionSheetAnimationDismissBlock:isBlock];
            } break;
            case ZHAnimationTypeAlert:
            {
                [self cancelAlertAnimationDismissBlock:isBlock];
            } break;
            default:
                break;
        }
    }
    else
    {
        [self animationCompletion:isBlock];
    }
}



//取消
- (void)cancelActionSheetAnimationDismissBlock:(BOOL)isBlock
{
    __weak typeof(self) weakSelf = self;
    [UIView animateWithDuration:KAniamtionDuration animations:^{
        weakSelf.shadowView.alpha = 0.0;
        weakSelf.top = MAINSCREEN_HEIGHT;
        //底部有按钮
        if (weakSelf.isNeedSafeBottomMargin) {
            weakSelf.sheetSafeBottomView.top = MAINSCREEN_HEIGHT;
        }
    } completion:^(BOOL finished)
     {
         [weakSelf animationCompletion:isBlock];
     }];
}

//取消
- (void)cancelAlertAnimationDismissBlock:(BOOL)isBlock
{
    __weak typeof(self) weakSelf = self;
    [UIView animateWithDuration:0.3 animations:^{
        weakSelf.alpha = 0.0;
        weakSelf.shadowView.alpha = 0.0;
    } completion:^(BOOL finished) {
        [weakSelf animationCompletion:isBlock];
    }];
}

- (void)animationCompletion:(BOOL)isBlock
{
    
    [self.belowShadowView removeFromSuperview];
    [self.shadowView removeFromSuperview];
    //需要安全区域适配，才会添加此视图
    if (self.isNeedSafeBottomMargin) {
        [self.sheetSafeBottomView removeFromSuperview];
    }
    [self removeFromSuperview];
    
    
    if (isBlock && self.dismissBlock) {
        self.dismissBlock();
    }
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    if (self.animationType == ZHAnimationTypeAlert)
    {
        self.center = CGPointMake(MAINSCREEN_WIDTH/2, MAINSCREEN_HEIGHT/2);
    }
}


- (UIView *)sheetSafeBottomView
{
    if (!_sheetSafeBottomView) {
        _sheetSafeBottomView = [[UIView alloc] init];
        _sheetSafeBottomView.backgroundColor = [UIColor whiteColor];
    }
    return _sheetSafeBottomView;
}

- (void)dealloc
{
    NSLog(@"%@",self);
}


- (UIWindow *)getKeyWindow
{
    NSEnumerator *frontToBackWindows = [UIApplication.sharedApplication.windows reverseObjectEnumerator];
    UIWindow * keyWindow = nil;
    for (UIWindow *window in frontToBackWindows){
        BOOL windowOnMainScreen = window.screen == UIScreen.mainScreen;
        BOOL windowIsVisible = !window.hidden && window.alpha > 0;
        BOOL windowLevelNormal = window.windowLevel == UIWindowLevelNormal;
        
        if (windowOnMainScreen && windowIsVisible && windowLevelNormal) {
            keyWindow = window;
            break;
        }
    }
    return keyWindow;
}

@end
