//
//  QGUpdateAlertView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGUpdateAlertView.h"
#import "QGBasicUITool.h"
#import "QGGradientShadowButton.h"

@interface QGUpdateAlertView ()

@property (nonatomic, strong) NSString * downloadUrl;

@end

@implementation QGUpdateAlertView

- (instancetype)initWithUpdateType:(NSInteger)updateType downloadUrl:(NSString *)downloadUrl title:(NSString *)title content:(NSString *)content
{
    if (self = [super init]) {
        
        
        self.contentView.backgroundColor = [UIColor clearColor];
        
        self.popType = PopViewTypeAlert;
        self.downloadUrl = downloadUrl;
        self.dissMissClickBackground = NO;
        
        //白色背景视图
        UIView * contentView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor whiteColor]];
        [contentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.inset(0);
            make.top.inset(46);
        }];
        
        contentView.layer.cornerRadius = 6;
        contentView.clipsToBounds = YES;
        
        //更新图片
        UIImageView * updateImg = [UIImageView creatImageViewWithSuperView:self.contentView imageName:@"app_updata"];
        [updateImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.size.mas_equalTo(CGSizeMake(154, 119));
            make.top.offset(0);
        }];
        
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:contentView title:title titleFontSize:[UIFont qg_mediumFontOfSize:20] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        titleLabel.numberOfLines = 0;
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.offset(77);
        }];
        
        //内容
        UILabel * contentLabel = [UILabel creatLabelWithSuperView:contentView title:content titleFontSize:[UIFont qg_regularFontOfSize:15] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        contentLabel.numberOfLines = 0;
        [contentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(16);
        }];
        
        //更新按钮
        QGGradientShadowButton * updateButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:contentView title:@"立即更新" textFont:[UIFont qg_regularFontOfSize:17]];
        [updateButton addTarget:self action:@selector(updateButtonClick) forControlEvents:UIControlEventTouchUpInside];
        
        //1强制更新，2推荐更新
        if (updateType == 1) {
            [updateButton mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.right.inset(35);
                make.height.mas_equalTo(40);
                make.top.mas_equalTo(contentLabel.mas_bottom).offset(20);
                make.bottom.inset(30);
            }];
        }
        else
        {
            [updateButton mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.right.inset(35);
                make.height.mas_equalTo(40);
                make.top.mas_equalTo(contentLabel.mas_bottom).offset(20);
            }];
            
            //暂不更新
            UIButton * cancelButton = [UIButton creatButtonWithSuperView:contentView title:@"暂不更新" titleFont:[UIFont qg_regularFontOfSize:15] textColor:[UIColor yyMainThemeColor]];
            [cancelButton mas_makeConstraints:^(MASConstraintMaker *make) {
                make.centerX.offset(0);
                make.top.mas_equalTo(updateButton.mas_bottom).offset(18);
                make.height.mas_equalTo(21);
                make.bottom.inset(20);
            }];
            
            [cancelButton addTarget:self action:@selector(cancelButtonClick) forControlEvents:UIControlEventTouchUpInside];
        }
        
        
    }
    return self;
}

- (void)cancelButtonClick
{
    [self dismissView:nil];
}

- (void)updateButtonClick
{
    if (self.downloadUrl.length > 0) {
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:self.downloadUrl]];
    }
}


@end
