//
//  QGBasePopView.h
//  VirtualPayment
//
//  Created by silicn on 2019/5/16.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

#ifndef kPopScreenWidth
#define kPopScreenWidth [UIScreen mainScreen].bounds.size.width
#endif
/// 左右边距
#define kLR_Margin ((42/375.0) * kPopScreenWidth)


NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,PopViewType) {
    PopViewTypeAlert, //弹窗
    PopViewTypeActionSheet, //sheet
};

typedef void(^PopViewDisMissBlock)(void);

@interface QGBasePopView : UIView

/**
 * 默认子类视图的父视图
 * 所有子类的子控件必须是contentView的子视图 example: [self.contentView addSubView:subView]
 */
@property (nonatomic, strong, readonly)UIView *contentView;

/**
 * 阴影视图下面的视图，透明度默认为0 当弹出动画时，需要在阴影底部做其他动画时使用
 */
@property (nonatomic, strong, readonly) UIView * belowShadowView;

///阴影的透明度 default is 0.5
@property (nonatomic, assign) CGFloat shadowViewAnimationAlpha;

///点击灰色部分是否关闭 default is YES
@property (nonatomic, assign) BOOL dissMissClickBackground;

///弹出的类型 default is PopViewTypeAlert
@property (nonatomic, assign) PopViewType popType;


/**
 Notice:
 1,子类初始化视图指定方法
 2,子类的视图的父视图必须是self.contentView
 3,子类视图的约束必须能撑起self.contentView的高度
 */
- (void)initNomalUI;


/**
 显示PopView

 @param superView PopView的父视图的Window，默认加载当前KeyWindow
 */
- (void)showInView:(nullable UIView *)superView;


/**
 销毁PopView

 @param dismissBlock 销毁PopView之后调用dismissBlock
 */
- (void)dismissView:(nullable PopViewDisMissBlock)dismissBlock;



/// 获取主window
- (UIWindow *)getKeyWindow;


@end

NS_ASSUME_NONNULL_END
