//
//  QGAlertView.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/20.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBasePopView.h"


///按钮点击block 取消按钮是 0 确认按钮是 1
typedef void(^QGAlertViewButtonClick)(NSInteger index);

typedef NS_ENUM(NSUInteger,QGAlertStyle)
{
    QGAlertStyleNomal = 0,  // 白色背景
    QGAlertStyleBlack       // 灰色背景
};

NS_ASSUME_NONNULL_BEGIN

/**
 功能同系统alert
 */
@interface QGAlertView : QGBasePopView

/// 弹窗样式,  默认是白色 
@property (nonatomic, assign)QGAlertStyle alertStyle;

/**
 确定按钮显示文案颜色  默认 mainThemeColor
 */
@property (nonatomic, strong) UIColor * sureButtonTextColor;

/**
 取消按钮显示文案颜色  默认 333333
 */
@property (nonatomic, strong) UIColor * cancleButtonTextColor;

/// 标题
@property (nonatomic, strong, readonly) UILabel * titleLabel;

/// 弹窗信息主体
@property (nonatomic, strong, readonly) UILabel * messageLabel;

/**
 实例化方法

 @param title 标题
 @param message 主要信息
 @param cancelButtonTitle 取消按钮
 @param sureButtonTitle 确认按钮
 @param clickBlock 点击的block
 @return 实例对象
 */
- (QGAlertView *)initWithTitle:(nullable NSString *)title message:(nonnull NSString *)message cancelButtonTitle:(nullable NSString *)cancelButtonTitle sureButtonTitle:(nullable NSString *)sureButtonTitle clickBlock:(nullable QGAlertViewButtonClick)clickBlock;

@end

NS_ASSUME_NONNULL_END
