//
//  DMOScalingImageView.m
//  Dreamore
//
//  Created by yushouren on 16/5/24.
//  Copyright © 2016年 zhangbo. All rights reserved.
//

#import "DMOScalingImageView.h"
#import "UIImageView+QGWebCache.h"
static const CGFloat MaxZommScale = 5.0;

@interface DMOScalingImageView () <UIScrollViewDelegate>

@property (nonatomic, strong) UIImageView *imageView;


@end

@implementation DMOScalingImageView

@synthesize imageURL = _imageURL;

#pragma mark - init

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        self.imageView = [[UIImageView alloc] initWithFrame:CGRectMake(0, 0, self.frame.size.width, self.frame.size.height)];
        [self.imageView setContentMode:UIViewContentModeScaleAspectFit];
        self.imageView.userInteractionEnabled = YES;
        [self addSubview:self.imageView];
        UILongPressGestureRecognizer *longPressGesture = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPressGestureHandler:)];
        [self.imageView addGestureRecognizer:longPressGesture];
        
        [self setDelegate:self];
        self.backgroundColor = [UIColor clearColor];
        [self setShowsHorizontalScrollIndicator:NO];
        [self setShowsVerticalScrollIndicator:NO];
        self.userInteractionEnabled = YES;
        UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tapGestureHandler:)];
        [self addGestureRecognizer:tapGesture];
    }
    return self;
}

- (void)setImageURL:(NSURL *)imageURL {
    if ([imageURL isEqual:_imageURL]) {
        return;
    }
    _imageURL = imageURL;
    __weak typeof(self) weakSelf = self;
    
    
    [self.imageView zb_setImageWithURL:imageURL placeholderImage:nil activityIndicatorVisible:YES complete:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {
        if (!error) {
            CGFloat width = weakSelf.frame.size.width;
            CGFloat height = image.size.height * weakSelf.frame.size.width / image.size.width;
            weakSelf.imageView.frame = CGRectMake(0, (weakSelf.frame.size.height - height) / 2, width, height);
            
            // pin gesture enable after download picture success.
            [weakSelf setMaximumZoomScale:MaxZommScale];
        }
        
    }];
}

#pragma mark - Gesture Handler

- (void)longPressGestureHandler:(UILongPressGestureRecognizer *)longPressGesture {
    // image place holder can not save.
    if (self.maximumZoomScale <= 1.0) {
        return;
    }
    
    if (longPressGesture.state == UIGestureRecognizerStateBegan) {
        if (self.longPressHandler) {
            self.longPressHandler(self.imageView.image);
        }
    }
}

- (void)tapGestureHandler:(UITapGestureRecognizer *)tapGesture {
    if (self.tapGestureHandler) {
        self.tapGestureHandler(self);
    }
}

#pragma mark - UIScrollViewDelegate

- (nullable UIView *)viewForZoomingInScrollView:(UIScrollView *)scrollView {
    return self.imageView;
}

- (void)scrollViewDidZoom:(UIScrollView *)scrollView {
    CGSize boundsSize = scrollView.bounds.size;
    CGRect imgFrame = self.imageView.frame;
    CGSize contentSize = scrollView.contentSize;
    
    CGPoint centerPoint = CGPointMake(contentSize.width / 2, contentSize.height / 2);
    if (imgFrame.size.width <= boundsSize.width) {
        centerPoint.x = boundsSize.width/2;
    }
    if (imgFrame.size.height <= boundsSize.height) {
        centerPoint.y = boundsSize.height/2;
    }
    self.imageView.center = centerPoint;
}

@end
