//
//  QGBannerView.m
//  CreditWallet
//
//  Created by 张博 on 17/3/7.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "QGBannerView.h"
#import "QGBannerCell.h"
#import "UIView+Extend.h"
#import "UIImage+CreditWallet.h"
#import "QGCountDown.h"
#import "QGCustomPageControl.h"
#import "UIImageView+WebCache.h"
#import "UIColor+QGColor.h"
@interface QGBannerView ()<UICollectionViewDelegate,UICollectionViewDataSource>

@property (nonatomic, assign) id <QGBannerViewDelegate> delegate;

@property (nonatomic, strong) UIImage * placeholderImage;

@property (nonatomic, strong) UICollectionView * collectionView;

/** 总共的页数 */
@property (nonatomic , assign) NSInteger totalPageCount;

/** 当前停留Index */
@property (nonatomic , assign) NSInteger currentPageIndex;

/** 定时器 */
@property (nonatomic, strong) QGCountDown * countDown;

/** 定时器的状态 是否暂停 */
@property (nonatomic, assign) BOOL isPause;

/** pageControl */
@property (nonatomic, strong) QGCustomPageControl * pageControl;

@end


@implementation QGBannerView

+ (instancetype)bannerViewWithFrame:(CGRect)frame delegate:(id<QGBannerViewDelegate>)delegate placeholderImage:(UIImage *)placeholderImage
{
    QGBannerView * bannerView = [[self alloc]initWithFrame:frame];
    bannerView.delegate = delegate;
    bannerView.placeholderImage = placeholderImage;
    return bannerView;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        [self initNormalUI];
    }
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)aDecoder
{
    if (self = [super initWithCoder:aDecoder]) {
        [self initNormalUI];
    }
    return self;
}


- (void)initNormalUI
{
    UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc]init];
    layout.minimumLineSpacing = 0;
    layout.minimumInteritemSpacing = 0;
    layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
    
    self.collectionView = [[UICollectionView alloc]initWithFrame:self.bounds collectionViewLayout:layout];
    self.collectionView.backgroundColor = [UIColor whiteColor];
    self.collectionView.scrollEnabled = YES;
    self.collectionView.pagingEnabled = YES;
    self.collectionView.delegate = self;
    self.collectionView.dataSource = self;
    self.collectionView.showsVerticalScrollIndicator = NO;
    self.collectionView.showsHorizontalScrollIndicator = NO;
    [self addSubview:self.collectionView];
    
    [self.collectionView registerClass:[QGBannerCell class] forCellWithReuseIdentifier:NSStringFromClass([QGBannerCell class])];
    
    self.pageControl = [[QGCustomPageControl alloc]init];
    self.pageControl.numberOfPages = self.imageUrlArray.count;
    self.pageControl.userInteractionEnabled = NO;
    self.pageControl.pageIndicatorTintColor = [[UIColor textColor9999] colorWithAlphaComponent:.4];
    self.pageControl.currentPageIndicatorTintColor = [UIColor textColor9999];
    self.pageControl.hidesForSinglePage = YES;
    
    [self addSubview:self.pageControl];
    
    
    _autoScrollTimeInterval = 0;
    _pageControlDotSize = CGSizeMake(5, 5);
    
    _isAutoScroll = YES;
    
    
    [self initTimer];
    [self resetPageControlUI];
}

///每次重置数据源时调用
- (void)resetPageControlFrame
{
    self.pageControl.numberOfPages = self.imageUrlArray.count;
    CGSize size = CGSizeMake(self.imageUrlArray.count * self.pageControlDotSize.width * 1.2, self.pageControlDotSize.height);
    
    CGFloat x = (self.width - size.width) * 0.5;
    if (self.alignmentStyle ==QGBannerPageControAlignmentLeft) {
        x=10;
    }else if (self.alignmentStyle ==QGBannerPageControAlignmentRight){
        x =self.width-size.width-10;
    }
    CGFloat y = self.collectionView.height - size.height - 10;
    //如果设置了pageControll距离底部的距离，则重新计算Y值
    if (self.pageMidIndent > 0) {
        y = self.collectionView.height + self.pageMidIndent;
    }
    self.pageControl.frame = CGRectMake(x, y, size.width, size.height);
}

- (void)initTimer
{
    if (self.autoScrollTimeInterval ==0) {
        return;
    }

    __weak typeof(self) weakSelf = self;
    self.countDown = [[QGCountDown alloc]init];
    [self.countDown countDownWithSEC:self.autoScrollTimeInterval isImmediatelySelector:NO eventBlock:^{
        [weakSelf automaticScroll];
    }];

}


#pragma mark - Setter
///设置图片链接数组
- (void)setImageUrlArray:(NSArray *)imageUrlArray
{
    if (_imageUrlArray != imageUrlArray) {
        _imageUrlArray = imageUrlArray;
        
        self.totalPageCount = _imageUrlArray.count;
        self.currentPageIndex = 0;
        //只有一条的时候，不轮播、不手滑、隐藏页码展示
        if (_imageUrlArray.count <= 1) {
            self.isAutoScroll = NO;
            self.collectionView.scrollEnabled = NO;
            self.pageControl.hidden = YES;
        }
        else
        {
            //如果有轮播时长，则开启自动轮播
            if (self.autoScrollTimeInterval > 0) {
                self.isAutoScroll = YES;
            }
            self.collectionView.scrollEnabled = YES;
            self.pageControl.hidden = NO;
        }
        
        [self resetPageControlFrame];
        [self configContentViews];
    }
}

///是否自动轮播
- (void)setIsAutoScroll:(BOOL)isAutoScroll
{
    _isAutoScroll = isAutoScroll;
    
    [self.countDown destoryTimer];
    self.countDown = nil;
    if (_isAutoScroll) {
        [self initTimer];
    }
}

///自动轮播间隔时长
- (void)setAutoScrollTimeInterval:(CGFloat)autoScrollTimeInterval
{
    _autoScrollTimeInterval = autoScrollTimeInterval;
    [self.countDown destoryTimer];
    self.countDown = nil;
    if (_isAutoScroll) {
        [self initTimer];
    }
}

///是否展示滑动指示器
- (void)setShowPageControl:(BOOL)showPageControl
{
    _showPageControl = showPageControl;
    self.pageControl.hidden = !_showPageControl;
}


///滑动指示器大小
- (void)setPageControlDotSize:(CGSize)pageControlDotSize
{
    if (!CGSizeEqualToSize(_pageControlDotSize, pageControlDotSize)) {
        _pageControlDotSize = pageControlDotSize;
        [self resetPageControlUI];
    }
}
- (void)setAlignmentStyle:(QGBannerPageControAlignment)alignmentStyle{
    if (_alignmentStyle !=alignmentStyle) {
        _alignmentStyle =alignmentStyle;
    }
    [self resetPageControlFrame];
}

///设置滑动指示器默认的点点背景
- (void)setPageImageName:(NSString *)pageImageName
{
    if (_pageImageName != pageImageName) {
        _pageImageName = pageImageName;
        self.pageControl.pageImageName = _pageImageName;
    }
}

///设置滑动指示器当前停留的点点背景
- (void)setCurrentPageImageName:(NSString *)currentPageImageName
{
    if (_currentPageImageName != currentPageImageName) {
        _currentPageImageName = currentPageImageName;
        self.pageControl.currentPageImageName = _currentPageImageName;
    }
}

///设置滑动指示器距离banner底部的距离
- (void)setPageMidIndent:(CGFloat)pageMidIndent
{
    if (_pageMidIndent != pageMidIndent) {
        _pageMidIndent = pageMidIndent;
        
        [self resetPageControlFrame];
    }
}


- (void)resetPageControlUI
{
    self.pageControl.indictorSpace = 5;
    self.pageControl.indictorSize = self.pageControlDotSize;
    self.pageControl.pageImageName = self.pageImageName;
    self.pageControl.currentPageImageName = self.currentPageImageName;
    [self resetPageControlFrame];
}


#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return 3;
}


- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGBannerCell * cell = (QGBannerCell *)[collectionView dequeueReusableCellWithReuseIdentifier:@"QGBannerCell" forIndexPath:indexPath];
    
    NSString * imageURL = nil;
    
    if (indexPath.row == 0) {
        NSInteger previousPageIndex = [self getValidNextPageIndexWithPageIndex:self.currentPageIndex - 1];
        if (self.imageUrlArray.count > previousPageIndex) {
            imageURL =  self.imageUrlArray[previousPageIndex];
        }
    }
    else if (indexPath.row == 1)
    {
        if (self.imageUrlArray.count > self.currentPageIndex) {
            imageURL =  self.imageUrlArray[self.currentPageIndex];
        }
    }
    else if (indexPath.row == 2)
    {
        NSInteger rearPageIndex = [self getValidNextPageIndexWithPageIndex:self.currentPageIndex + 1];
        if (self.imageUrlArray.count > rearPageIndex) {
            imageURL =  self.imageUrlArray[rearPageIndex];
        }
        
    }
    [cell.bannerImageView sd_setImageWithURL:[NSURL URLWithString:imageURL] placeholderImage:self.placeholderImage];
    return cell;
}

#pragma mark - UICollectionViewDlegate
- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(nonnull NSIndexPath *)indexPath
{
    if (self.delegate && [self.delegate respondsToSelector:@selector(bannerView:didSelectItemAtIndex:)]) {
        [self.delegate bannerView:self didSelectItemAtIndex:self.currentPageIndex];
    }
}

#pragma mark --UICollectionViewDelegateFlowLayout
//定义每个Item 的大小
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return CGSizeMake(self.collectionView.width, self.collectionView.height);
}

//定义每个UICollectionView 的 margin
-(UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout insetForSectionAtIndex:(NSInteger)section
{
    return UIEdgeInsetsMake(0, 0, 0, 0);
}



/* 定时器自动滑动方法 */
- (void)automaticScroll
{
    if (self.totalPageCount == 0) {
        return;
    }
    [self.collectionView setContentOffset:CGPointMake(self.collectionView.width * 2, 0) animated:YES];
}




//保证数组不会出现越界
- (NSInteger)getValidNextPageIndexWithPageIndex:(NSInteger)currentPageIndex;
{
    if(currentPageIndex == -1) {
        return self.totalPageCount - 1;
    } else if (currentPageIndex == self.totalPageCount) {
        return 0;
    } else {
        return currentPageIndex;
    }
}

#pragma mark - UIScrollViewDelegate
- (void)scrollViewWillBeginDragging:(UIScrollView *)scrollView
{
    if (self.isAutoScroll) {
        [self pauseTimer];
    }
    
}

- (void)scrollViewDidEndDragging:(UIScrollView *)scrollView willDecelerate:(BOOL)decelerate
{
    if (self.isAutoScroll) {
        [self resumeTimer];
    }
    
}

- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    //非空判断
    if (self.totalPageCount == 0) {
        return;
    }
    CGFloat contentOffsetX = scrollView.contentOffset.x;
//    NSLog(@"_______%f",contentOffsetX);
    if(contentOffsetX >= (2 * CGRectGetWidth(scrollView.frame))) {
        self.currentPageIndex = [self getValidNextPageIndexWithPageIndex:self.currentPageIndex + 1];
        [self configContentViews];
//        NSLog(@"111 next，当前页:%d",self.currentPageIndex);
    }
    if(contentOffsetX <= 0) {
        self.currentPageIndex = [self getValidNextPageIndexWithPageIndex:self.currentPageIndex - 1];
        [self configContentViews];
//        NSLog(@"222 next，当前页:%d",self.currentPageIndex);
    }
    
    self.pageControl.currentPage = self.currentPageIndex;
}


- (void)configContentViews
{
    [self.collectionView setContentOffset:CGPointMake(CGRectGetWidth(self.collectionView.frame), 0) animated:NO];
    [self.collectionView reloadData];
}




- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView
{
    [scrollView setContentOffset:CGPointMake(CGRectGetWidth(scrollView.frame), 0) animated:YES];
}



#pragma Timer事件

- (void)pauseTimer
{
    //如果处于启动状态
    if (!self.isPause) {
        [self.countDown destoryTimer];
        self.countDown = nil;
    }
    self.isPause = YES;
}

- (void)resumeTimer
{
    //如果处于暂停状态
    if (self.isPause) {
        [self initTimer];
    }
    self.isPause = NO;
    
}

//解决当父View释放时，当前视图因为被Timer强引用而不能释放的问题
- (void)willMoveToSuperview:(UIView *)newSuperview
{
    [super willMoveToSuperview:newSuperview];
    if (!newSuperview) {
        [self.countDown destoryTimer];
        self.countDown = nil;
    }
}





- (void)dealloc
{
    
}


@end
