//
//  QGBannerView.h
//  CreditWallet
//
//  Created by 张博 on 17/3/7.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import <UIKit/UIKit.h>
@class QGBannerView;
typedef NS_ENUM(NSInteger, QGBannerPageControAlignment) {
    QGBannerPageControAlignmentCenter    = 0,    // 居中
    QGBannerPageControAlignmentLeft      = 1,    // 居左
    QGBannerPageControAlignmentRight     = 2,    // 居右

} ;

@protocol QGBannerViewDelegate <NSObject>

/** 点击图片回调 */
- (void)bannerView:(QGBannerView *)bannerView didSelectItemAtIndex:(NSInteger)index;


@end


/**
 banner控件
 */
@interface QGBannerView : UIView

@property (nonatomic, strong) NSArray * imageUrlArray;

/** 是否自动滚动，默认值为YES */
@property (nonatomic, assign) BOOL isAutoScroll;

/** 自动滚动间隔时间,默认5s */
@property (nonatomic, assign) CGFloat autoScrollTimeInterval;

/** 是否显示分页控件 */
@property (nonatomic, assign) BOOL showPageControl;

/** 分页控件小圆标大小 */
@property (nonatomic, assign) CGSize pageControlDotSize;

/** 分页控件布局 */
@property (nonatomic )  QGBannerPageControAlignment alignmentStyle ;

/**
 分页控件默认背景图片名称
 */
@property (nonatomic, copy) NSString * pageImageName;

/**
 分页控件选中状态下的背景图片名称
 */
@property (nonatomic, copy) NSString * currentPageImageName;

/**pageControll与图分离，在底部时与图的间距*/
@property (nonatomic, assign) CGFloat pageMidIndent;


+ (instancetype)bannerViewWithFrame:(CGRect)frame delegate:(id<QGBannerViewDelegate>)delegate placeholderImage:(UIImage *)placeholderImage;

@end
