//
//  UIView+LayoutSubviewsCallback.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/16.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "UIView+LayoutSubviewsCallback.h"
#import "SwizzleMethod.h"
#import <objc/runtime.h>
@implementation UIView (LayoutSubviewsCallback)

+ (void)load
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        Class class = [self class];
        swizzleMethod(class, @selector(layoutSubviews), @selector(aop_layoutSubviews));
    });
}

- (void)aop_layoutSubviews
{
    [self aop_layoutSubviews];
    if (self.layoutSubviewsCallback) {
        self.layoutSubviewsCallback(self);
    }
}


#pragma mark - Get
- (UIViewLayoutSubviewsCallback)layoutSubviewsCallback
{
    return objc_getAssociatedObject(self, @selector(layoutSubviewsCallback));
}

#pragma mark - Set
- (void)setLayoutSubviewsCallback:(UIViewLayoutSubviewsCallback)layoutSubviewsCallback
{
    objc_setAssociatedObject(self, @selector(layoutSubviewsCallback), layoutSubviewsCallback, OBJC_ASSOCIATION_COPY);
}



@end
