//
//  NSString+CreditWallet.h
//  CreditWallet
//
//  Created by 逍遥子 on 2016/11/14.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
@interface NSString (CreditWallet)

///字符串取值
#define IsStringNull(str) [NSString isEmpty:(str)]?@"":(str)

/**
 汉字转拼音
 
 @return 目标拼音
 */
- (NSString *)transformToPinyin;

/**
 JSON格式的字符串转换成字典

 @param jsonString json字符串
 @return 字典
 */
+ (NSDictionary *)dictionaryWithJsonString:(NSString *)jsonString;

/**
 字典转换成json格式的字符串

 @param dic 字典
 @return json格式字符串
 */
+ (NSString *)dictionaryToJson:(NSDictionary *)dic;

/**
 返回不为null的字符串

 @param string 需要处理的字符串或者nil
 @return 目标字符串
 */
+ (NSString *)getCheckString:(NSString *)string;

/**
 获取固定字符串的高度
 
 @param content 字符串
 @param width 最大宽度
 @param font 字体大小
 @return 目标高度
 */
+ (CGFloat)getHeightWithContent:(NSString *)content width:(CGFloat)width UIFont:(UIFont *)font;

/**
 获取固定字符串的宽度
 
 @param content 字符串
 @param height 最大高度
 @param font 字体大小
 @return 目标宽度
 */
+ (CGFloat)getWidthWithContent:(NSString *)content height:(CGFloat)height UIFont:(UIFont *)font;

/**
 计算字符串大小
 
 @param font 字体
 @param maxSize 最大size
 @return 目标size
 */
- (CGSize)sizeWithFont:(UIFont *)font maxSize:(CGSize)maxSize;

/**
 是否包含某段字符

 @param string 匹配字符串
 @return 目标结果
 */
- (BOOL)isContainOfString:(NSString *)string;

/**
 是否是身份证号
 
 @return 目标结果
 */
- (BOOL)isIdentityCard;

/**
 邮箱正则

 @return 目标结果
 */
- (BOOL)isEmail;

/**
 是否为数字
 
 @return YES 数字 NO 不是
 */
- (BOOL)isNumber;

/**
 md5

 @return md5之后的字符串
 */
- (NSString *)md5;

/**
 参照URLQueryAllowedCharacterSet以及stringByReplacingPercentEscapesUsingEncoding，需要encode的字符集

 @param string 需要处理字符串
 @return 目标字符串
 */
+ (NSString *)urlEncodeString:(NSString *)string;

/**
 拼接URL

 @param baseURL 基础字符串
 @param params 字典参数
 @return 目标字符串
 */
+ (NSString *)serializeURL:(NSString *)baseURL params:(NSDictionary *)params;

/**
 根据URL 解析出query里面的字典

 @param queryString 需要解析字符串
 @return 解析字典结果
 */
+ (NSDictionary *)explodeQueryStringToDictionary:(NSString *)queryString;

/**
 判断一个字符串中是否包含汉字
 
 @param aString 待判断的字符串
 @return yes - 包含中文字符  no - 不包含中文字符
 */
+ (BOOL)isContainChinese:(NSString *)aString;

/**
 获取首个字母，如果是汉字，则为汉字对应的拼音首字母
 
 @param aString 待处理的字符串
 @return 字符串首字母
 */
+ (NSString *)firstCharactor:(NSString *)aString;

/**
 七牛云 图片url支持webp
 
 @param urlStr url
 @return webpUrl
 */
+ (NSString *)addWebPFormatFromUrlStr:(NSString *)urlStr;

/**
 判断字符串是否为空

 @param string NSString
 @return BOOL值
 */
+ (BOOL)isEmpty:(NSString *)string;


/**
 是否是符合项目要求的密码
 @return yes符合
 */
-(BOOL)isValidPasswordString;

/**
 是否是合法的地址
 匹配规则汉字，字母，数字，-，# ,以及 .. ，。
 */
- (BOOL)isLegalAddress;

/**
 是否仅仅包含数字和字母
 */
- (BOOL)isOnlyContainsNumberAndLetter;


/// 格式化银行卡号
- (NSString *)formatterBankCardNum;


@end
