//
//  QGNotifyDetailContentCell.m
//  CreditWallet
//
//  Created by 金修博 on 2017/12/29.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "QGNotifyDetailContentCell.h"
#import "QGBasicUITool.h"
#import "ZHAttributedLabelTool.h"
#import "ZHHitLabel.h"
#import "QGApplicationOpenURL.h"

@implementation QGNotifyDetailContentCell

- (void)awakeFromNib {
    [super awakeFromNib];
    
    self.contentLbl.font = [UIFont qg_lightFontOfSize:13];
}

- (void)setContent:(NSString *)content {
    _content = content;
    
    ZHAttributedLabelTool *attributedTextTool = [[ZHAttributedLabelTool alloc] initWithText:content
                                                                                       font:[UIFont qg_lightFontOfSize:13]
                                                                                      color:[UIColor colorWithHexString:@"717171"]];
    
    //设置换行方式
    [attributedTextTool setLineBreakMode:NSLineBreakByCharWrapping];
    
    //行间距
    [attributedTextTool setLineSpacing:2.f];
    
    [attributedTextTool setLabelPropertyWithLabel:self.contentLbl];
    
    /*
    //设置可点击的文字
    NSError *error;
    NSDataDetector *dataDetector=[NSDataDetector dataDetectorWithTypes:NSTextCheckingTypeLink error:&error];
    NSArray *arrayOfAllMatches=[dataDetector matchesInString:content options:NSMatchingReportProgress range:NSMakeRange(0, content.length)];
    
    NSMutableDictionary *matchRanges = [NSMutableDictionary dictionary];
    
    for (NSTextCheckingResult *match in arrayOfAllMatches){
        
        NSString *urlStr = [content substringWithRange:match.range];
        
        [matchRanges setValue:urlStr forKey:NSStringFromRange(match.range)];
        
        //链接文字高亮显示
        [attributedTextTool addRichHelpWithType:ZHRichHelpTypeClick range:match.range color:[UIColor mainThemeColor]];
    }
    
    [attributedTextTool setLabelPropertyWithLabel:self.contentLbl];
    
    self.contentLbl.clickBlock = ^(ZHRichHelpModel *model) {
        NSString *valueRangeStr = NSStringFromRange(model.valueRange);
        if ([matchRanges.allKeys containsObject:valueRangeStr]) {
            NSString *urlStr = [matchRanges valueForKey:valueRangeStr];
            [QGApplicationOpenURL handleAllSupportUrl:urlStr];
        }
    };
     */
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
