//
//  QGMessageBottomView.m
//  CreditWallet
//
//  Created by harry on 31/12/2017.
//  Copyright © 2017 QuantGroup. All rights reserved.
//

#import "QGMessageBottomView.h"
#import "QGBasicUITool.h"
#import "UIView+Extend.h"
#import "UIFont+QGFont.h"
#import "UIImage+CreditWallet.h"


static const NSInteger kQGMessageBottomSubTag = 11001;

@interface QGMessageBottomView ()

@end

@implementation QGMessageBottomView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    //背景颜色
    self.backgroundColor = [UIColor whiteColor];
    
    //分割线
    UIView *topLine = [[UIView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 1)];
    topLine.backgroundColor = [UIColor lineSeparatorColorDCDC];
    [self addSubview:topLine];
    
    NSInteger tag = kQGMessageBottomSubTag;
    //全选按钮
    UIButton *allSelectBtn = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 80, 50)];
    allSelectBtn.imageView.width = 18;
    allSelectBtn.imageView.height = 18;
    [allSelectBtn setImage:[UIImage imageNamed:@"MyCollect_normal"] forState:UIControlStateNormal];
    [allSelectBtn setImage:[UIImage imageNamed:@"MyCollect_selected"] forState:UIControlStateSelected];
    [allSelectBtn setTitle:@"全选" forState:UIControlStateNormal];
    [allSelectBtn setTitleColor:[UIColor textColor6666] forState:UIControlStateNormal];
    [allSelectBtn setTitleColor:[UIColor grayColor] forState:UIControlStateHighlighted];
    allSelectBtn.titleLabel.font = [UIFont systemFontOfSize:14.0];
    [allSelectBtn addTarget:self action:@selector(allSelectBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [allSelectBtn setTitleEdgeInsets:UIEdgeInsetsMake(0, 15, 0, 0)];
    allSelectBtn.tag = tag;
    [self addSubview:allSelectBtn];
    tag++;
    
    CGSize btnSize = CGSizeMake(70.f, 30.f);
    //删除按钮
    UIButton *readBtn = [[UIButton alloc] initWithFrame:CGRectMake(MAINSCREEN_WIDTH-90-90, 10, btnSize.width, btnSize.height)];
    [readBtn setBackgroundImage:[UIImage imageWithColor:[UIColor whiteColor] size:btnSize] forState:UIControlStateNormal];
    [readBtn setTitle:@"标为已读" forState:UIControlStateNormal];
    readBtn.layer.masksToBounds = YES;
    readBtn.layer.cornerRadius = 4.f;
    readBtn.layer.borderColor = [UIColor textColor9999].CGColor;
    readBtn.layer.borderWidth = 1.f;
    readBtn.titleLabel.font = [UIFont qg_lightFontOfSize:13];
    [readBtn setTitleColor:[UIColor textColor9999] forState:UIControlStateNormal];
    [readBtn addTarget:self action:@selector(readBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    readBtn.tag = tag;
    readBtn.userInteractionEnabled = NO;
    [self addSubview:readBtn];
    tag++;
    
    //删除按钮
    UIButton *deleteBtn = [[UIButton alloc] initWithFrame:CGRectMake(MAINSCREEN_WIDTH-90, 10, btnSize.width, btnSize.height)];
    deleteBtn.backgroundColor = [UIColor mainThemeColor];
    [deleteBtn setTitle:@"删除" forState:UIControlStateNormal];
    [deleteBtn setBackgroundImage:[UIImage imageWithColor:[UIColor whiteColor] size:btnSize] forState:UIControlStateNormal];
    [deleteBtn setTitleColor:[UIColor textColor9999] forState:UIControlStateNormal];
    deleteBtn.layer.masksToBounds = YES;
    deleteBtn.layer.cornerRadius = 4.f;
    deleteBtn.layer.borderColor = [UIColor textColor9999].CGColor;
    deleteBtn.layer.borderWidth = 1.f;
    deleteBtn.titleLabel.font = [UIFont qg_lightFontOfSize:13];
    [deleteBtn addTarget:self action:@selector(deleteBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    deleteBtn.tag = tag;
    deleteBtn.userInteractionEnabled = NO;
    [self addSubview:deleteBtn];
    
}

- (void)setType:(MessageCenterListType)type{
    NSInteger tag = kQGMessageBottomSubTag+1;
    UIButton *readBtn = [self viewWithTag:tag];
    if (_type != type){
        _type = type;
        switch (_type) {
            case MessageCenterListTypeNotifyMsg:{
                if (readBtn && readBtn.hidden) {
                    readBtn.hidden = NO;
                }
                break;
            }
            case MessageCenterListTypeActivityMsg:{
                if (readBtn && !readBtn.hidden) {
                    readBtn.hidden = YES;
                }
                break;
            }
                
            default:
                break;
        }
    }
}

- (void)updateReadBtnState:(BOOL)readEnabled deleteBtnState:(BOOL)deleteEnabled{
    NSInteger tag = kQGMessageBottomSubTag+1;
    UIButton *readBtn = [self viewWithTag:tag];
    tag++;
    UIButton *deleteBtn = [self viewWithTag:tag];
    if (readBtn && !readBtn.hidden) {
        if (readEnabled) {
            [readBtn setTitleColor:[UIColor colorWithHexString:@"333333"] forState:UIControlStateNormal];
            readBtn.layer.borderColor = [UIColor colorWithHexString:@"333333"].CGColor;
            readBtn.userInteractionEnabled = YES;
        }else{
            [readBtn setTitleColor:[UIColor colorWithHexString:@"999999"] forState:UIControlStateNormal];
            readBtn.layer.borderColor = [UIColor colorWithHexString:@"999999"].CGColor;
            readBtn.userInteractionEnabled = NO;
        }
    }
    if (deleteBtn && !deleteBtn.hidden) {
        if (deleteEnabled) {
            [deleteBtn setTitleColor:[UIColor colorWithHexString:@"333333"] forState:UIControlStateNormal];
            deleteBtn.layer.borderColor = [UIColor colorWithHexString:@"333333"].CGColor;
            deleteBtn.userInteractionEnabled = YES;
        }else{
            [deleteBtn setTitleColor:[UIColor colorWithHexString:@"999999"] forState:UIControlStateNormal];
            deleteBtn.layer.borderColor = [UIColor colorWithHexString:@"999999"].CGColor;
            deleteBtn.userInteractionEnabled = NO;
        }
    }


}

#pragma mark - 按钮响应事件
- (void)allSelectBtnClick:(UIButton *)sender {
    sender.selected = !sender.isSelected;
    if ([self.delegate respondsToSelector:@selector(messageBottomView:clickAllselectedButton:)]) {
        [self.delegate messageBottomView:self clickAllselectedButton:sender];
    }
}

- (void)readBtnClick:(UIButton *)sender {
    if ([self.delegate respondsToSelector:@selector(messageBottomView:clickReadButton:)]) {
        [self.delegate messageBottomView:self clickReadButton:sender];
    }
}

- (void)deleteBtnClick:(UIButton *)sender {
    if ([self.delegate respondsToSelector:@selector(messageBottomView:clickDeleteButton:)]) {
        [self.delegate messageBottomView:self clickDeleteButton:sender];
    }
}

- (void)setSelectAllBtnSelectedState:(BOOL)is_selected{
    NSInteger tag = kQGMessageBottomSubTag;
    UIButton *allSelectBtn = [self viewWithTag:tag];
    allSelectBtn.selected = is_selected;
}

/*
 // Only override drawRect: if you perform custom drawing.
 // An empty implementation adversely affects performance during animation.
 - (void)drawRect:(CGRect)rect {
 // Drawing code
 }
 */

@end
