//
//  QGEditBaseCell.m
//  CreditWallet
//
//  Created by harry on 28/12/2017.
//  Copyright © 2017 QuantGroup. All rights reserved.
//

#import "QGEditBaseCell.h"
#import "UIView+Extend.h"
#import "UIColor+QGColor.h"
#import "QGAppMacro.h"
#import "Masonry.h"



@interface QGEditBaseCell ()


@end

@implementation QGEditBaseCell

- (void)dealloc{
    self.delegate = nil;
}

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        //手势
        UITapGestureRecognizer *tapGes = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tapGesClick)];
        [self addGestureRecognizer:tapGes];
    }
    return self;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    [self changeStyle];
}

- (void)setHighlighted:(BOOL)highlighted animated:(BOOL)animated {
    [super setHighlighted:highlighted animated:animated];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    [self changeStyle];
}

- (void)setEditing:(BOOL)editing animated:(BOOL)animated {
    [super setEditing:editing animated:animated]; 
    [self changeStyle];
}

- (void)updateModel:(QGMessageListModel *)model{
    
}

- (void)tapGesClick{
    if ([self.delegate respondsToSelector:@selector(didSelectedEditCell:)]) {
        [self.delegate didSelectedEditCell:self];
    }
}

#pragma mark-

/**
 改变编辑状态下Cell 默认单选按钮的图片样式和大小
 */
- (void)changeStyle {
    for (UIControl *control in self.subviews) {
        if ([control isMemberOfClass:NSClassFromString(@"UITableViewCellEditControl")]) {
            
            for (UIView *v in control.subviews) {
                if ([v isKindOfClass: [UIImageView class]]) {
                    UIImageView *img=(UIImageView *)v;
                    if (self.selected) {
                        img.image=[UIImage imageNamed:@"MyCollect_selected"];
                    }
                    if (self.highlighted) {
                        img.image=[UIImage imageNamed:@"MyCollect_normal"];
                    }
                    if (!self.selected) {
                        img.image=[UIImage imageNamed:@"MyCollect_normal"];
                    }
                    img.width = 18;
                    img.height = 18;
                }
            }
        }
    }
}

@end
