//
//  QGActivityCell.m
//  CreditWallet
//
//  Created by harry on 29/12/2017.
//  Copyright © 2017 QuantGroup. All rights reserved.
//

#import "QGActivityCell.h"
#import "QGMessageListModel.h"
#import "UIFont+QGFont.h"
#import "UIColor+QGColor.h"
#import "ZHAttributedLabelTool.h"
#import "QGAppMacro.h"
#import "UIImageView+WebCache.h"
#import "UIView+Extend.h"
#import "QGBasicUITool.h"

@interface QGActivityCell (){
    UIView *_myContentView;
    UIImageView *_imageView;
    UILabel *_timeLabel;
    UILabel *_titleLabel;
    UILabel *_contentLabel;
    UILabel *_finishLabel;
    UIButton *_button;
    UIView *_line;
    CAShapeLayer *_shapelayer;
    QGMessageListModel *_model;
}


@end

@implementation QGActivityCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        UIColor *color = [UIColor colorWithHexString:@"f6f6f6"];
        self.backgroundColor = color;
        self.contentView.backgroundColor = self.backgroundColor;
        self.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    return self;
}


- (void)updateModel:(QGMessageListModel *)model{
    if (model) {
        _model = model;
        if (!_timeLabel){
            _timeLabel = [[UILabel alloc] init];
            _timeLabel.font = [UIFont qg_lightFontOfSize:11];
            _timeLabel.textColor = [UIColor textColor9999];
            _timeLabel.numberOfLines = 1;
            _timeLabel.backgroundColor = [UIColor colorWithHexString:@"f6f6f6"];
            _timeLabel.textAlignment = NSTextAlignmentCenter;
        }
        _timeLabel.text = model.msgTime;
        if (!_timeLabel.superview) {
            [self.contentView addSubview:_timeLabel];
        }
        _timeLabel.frame = CGRectMake(0, 10, MAINSCREEN_WIDTH, ceilf([[UIFont qg_lightFontOfSize:11] lineHeight]));//时间文本保持原始比例
        
        
        CGRect frame = CGRectMake(20, CGRectGetMaxY(_timeLabel.frame)+10.f, MAINSCREEN_WIDTH-40,206*Screen_Scaling);
        if (!_myContentView) {
            _myContentView = [[UIView alloc] init];
            _myContentView.userInteractionEnabled = NO;
            _myContentView.backgroundColor = [UIColor whiteColor];
            CGFloat cornerRadius = 3*Screen_Scaling;
            UIBezierPath *shapePath = [UIBezierPath bezierPathWithRoundedRect: CGRectMake(0, 0,CGRectGetWidth(frame), CGRectGetHeight(frame)) cornerRadius:cornerRadius];
            CAShapeLayer *shapelayer = [CAShapeLayer layer];
            shapelayer.path = shapePath.CGPath;
            shapelayer.fillColor = [UIColor whiteColor].CGColor;
            shapelayer.shadowOffset = CGSizeMake(0,2*Screen_Scaling);
            shapelayer.shadowColor = [[UIColor colorWithHexString:@"000000"] colorWithAlphaComponent:.5f].CGColor;
            shapelayer.shadowOpacity = .2;
            shapelayer.shadowRadius = 4.f;
            shapelayer.rasterizationScale = [UIScreen mainScreen].scale;
            shapelayer.shouldRasterize = YES;
            shapelayer.shadowPath = shapePath.CGPath;
            _shapelayer = shapelayer;
            
            _myContentView.layer.masksToBounds = YES;
            _myContentView.layer.cornerRadius = cornerRadius;
            _myContentView.layer.rasterizationScale = [UIScreen mainScreen].scale;
            _myContentView.layer.shouldRasterize = YES;
            _myContentView.clipsToBounds = YES;
        }
        if (!_shapelayer.superlayer){
            [self.contentView.layer addSublayer:_shapelayer];
        }
        if (!_myContentView.superview) {
            [self. contentView addSubview:_myContentView];
        }
   

        _myContentView.frame = frame;
        _shapelayer.frame = frame;

        
        if (!_imageView) {
            _imageView = [[UIImageView alloc] init];
        }
        if (!_imageView.superview) {
            [_myContentView addSubview:_imageView];
        }
        NSURL *url = nil;
        if (model.imgUrl){
            url = [NSURL URLWithString:model.imgUrl];
        }
        [_imageView sd_setImageWithURL:url placeholderImage:[UIImage imageNamed:@"messageDefaultIcon"]];
        CGFloat scale = 96.f/335.f;
        _imageView.frame = CGRectMake(0, 0, CGRectGetWidth(_myContentView.frame), CGRectGetWidth(_myContentView.frame)*scale);
 
        
        CGFloat width = CGRectGetWidth(_myContentView.frame)-20*Screen_Scaling;
        CGFloat indent = 10*Screen_Scaling;
        UIFont *font = [UIFont qg_regularFontOfSize:15*Screen_Scaling];
        UIColor *textColor = [UIColor whiteColor];
        
        if (!_finishLabel){
            _finishLabel = [[UILabel alloc] init];
            _finishLabel.numberOfLines = 1;
            _finishLabel.font = font;
            _finishLabel.textAlignment = NSTextAlignmentCenter;
            _finishLabel.backgroundColor = [UIColor colorWithWhite:0.f alpha:0.8f];
        }
        _finishLabel.textColor = textColor;
        if (!_finishLabel.superview) {
            [_myContentView addSubview:_finishLabel];
        }
        _finishLabel.text = @"活动已结束";
        CGFloat labelHeight = 30*Screen_Scaling;
        _finishLabel.frame = CGRectMake(0,CGRectGetHeight(_imageView.frame)-labelHeight, CGRectGetWidth(_imageView.frame), labelHeight);
        
        UIColor *titleColor = [UIColor textColor3333];
        UIColor *contentColor = [UIColor textColor6666];
        UIColor *btnColor = [UIColor textColor6666];
        if (model.navExpire && [model.navExpire boolValue]) {//YES 期满失效
            _myContentView.alpha = 0.6f;
            _shapelayer.opacity = 0.6f;
            _finishLabel.hidden= NO;
            UIColor *expireColor = [UIColor colorWithHexString:@"999999"];
            titleColor = expireColor;
            contentColor = expireColor;
            btnColor = expireColor;
        }else{
            _myContentView.alpha = 1.f;
            _shapelayer.opacity = 1.f;
            _finishLabel.hidden= YES;
        }
        
        font = [UIFont qg_regularFontOfSize:14*Screen_Scaling];
        textColor = titleColor;
        if (!_titleLabel){
            _titleLabel = [[UILabel alloc] init];
            _titleLabel.numberOfLines = 1;
            _titleLabel.textAlignment = NSTextAlignmentLeft;
        }
        _titleLabel.font = font;
        _titleLabel.textColor = textColor;
        if (!_titleLabel.superview) {
            [_myContentView addSubview:_titleLabel];
        }
        if (!model.title) {
            model.title = @"";
        }
        _titleLabel.text = model.title;
        _titleLabel.frame = CGRectMake(indent,CGRectGetMaxY(_imageView.frame)+15*Screen_Scaling, width, ceilf([font lineHeight]));
        
        
        font = [UIFont qg_lightFontOfSize:12*Screen_Scaling];
        textColor = contentColor;
        if (!_contentLabel){
            _contentLabel = [[UILabel alloc] init];
            _contentLabel.numberOfLines = 2;
            _contentLabel.textAlignment = NSTextAlignmentLeft;
        }
        _contentLabel.font = font;
        _contentLabel.textColor = textColor;
        if (!_contentLabel.superview) {
            [_myContentView addSubview:_contentLabel];
        }
        if (!model.content) {
            model.content = @"";
        }
        ZHAttributedLabelTool *attTool = [[ZHAttributedLabelTool alloc] initWithText:model.content font:font color:textColor];
        [attTool setLineSpacing:1];
        [attTool setLineBreakMode:NSLineBreakByTruncatingTail];
        [attTool setLabelPropertyWithLabel:_contentLabel];
        _contentLabel.frame = CGRectMake(indent,CGRectGetMaxY(_titleLabel.frame)+5*Screen_Scaling, width, 40*Screen_Scaling);
        [_contentLabel sizeToFit];
        
        
        if (!_line){
            _line = [[UIView alloc] init];
            _line.userInteractionEnabled = NO;
        }
        _line.backgroundColor = [UIColor colorWithHexString:@"DCDCDC"];
     
        _line.frame = CGRectMake(0, 176*Screen_Scaling, CGRectGetWidth(_myContentView.frame), 0.5f);
        if (!_button) {
            _button = [[UIButton alloc] init];
            _button.titleLabel.font = font;
            _button.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
            _button.contentVerticalAlignment = UIControlContentVerticalAlignmentCenter;
            _button.userInteractionEnabled = NO;
        }
        if (!_button.superview){
            [_myContentView addSubview:_button];
        }
        [_button setTitle:@"查看详情" forState:UIControlStateNormal];
        [_button setTitleColor:btnColor forState:UIControlStateNormal];
        [_button setImage:[UIImage imageNamed:@"classify_more_arrow"] forState:UIControlStateNormal];
        _button.frame = CGRectMake(indent, 176*Screen_Scaling, 64*Screen_Scaling, 30*Screen_Scaling);
        
        if (!_line.superview) {
            [_myContentView addSubview:_line];
        }
        CGFloat imageWith = _button.imageView.bounds.size.width;
        CGFloat labelWidth = _button.titleLabel.bounds.size.width+3*Screen_Scaling;
        [_button setImageEdgeInsets:UIEdgeInsetsMake(0, labelWidth, 0, -labelWidth)];
        [_button setTitleEdgeInsets:UIEdgeInsetsMake(0, -imageWith, 0, imageWith)];
    }    
}

- (void)layoutSubviews {
    [super layoutSubviews];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

- (void)setHighlighted:(BOOL)highlighted animated:(BOOL)animated {
    [super setHighlighted:highlighted animated:animated];
}

- (void)setEditing:(BOOL)editing animated:(BOOL)animated {
    [super setEditing:editing animated:animated];
}


#pragma mark- OverWrite
- (void)changeStyle {
    for (UIControl *control in self.subviews) {
        if ([control isMemberOfClass:NSClassFromString(@"UITableViewCellEditControl")]) {
            for (UIView *v in control.subviews) {
                if ([v isKindOfClass: [UIImageView class]]) {
                    UIImageView *img=(UIImageView *)v;
                    img.contentMode = UIViewContentModeBottom;
                    if (self.selected) {
                        img.image = [UIImage imageNamed:@"activityEditSelectIcon"];
                    }
                    if (self.highlighted) {
                        img.image = [UIImage imageNamed:@"activityEditIcon"];
                    }
                    if (!self.selected) {
                        img.image = [UIImage imageNamed:@"activityEditIcon"];
                    }
                    img.width = 18;
                    img.height = 38;
                }
            }
        }
    }
}



@end

