//
//  QGNotifyDetailController.m
//  CreditWallet
//
//  Created by 金修博 on 2017/12/29.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "QGNotifyDetailController.h"
#import "QGMessageListModel.h"
#import "QGNotifyDetailContentCell.h"
#import "QGNotifyDetailTitleCell.h"

@interface QGNotifyDetailController () <UITableViewDelegate, UITableViewDataSource>

@end

@implementation QGNotifyDetailController

- (BOOL)checkParameters:(NSDictionary *)param {
    if (![param valueForKey:@"msgListModel"]) {
        return NO;
    }
    return YES;
}

- (void)transferParameters:(NSDictionary *)param {
    NSArray *keys = param.allKeys;
    if (keys.count == 0) {
        return;
    }

    if ([keys containsObject:@"title"]) {
        self.title = param[@"title"];
    }
    if ([keys containsObject:@"msgListModel"]) {
        self.msgListModel = [param valueForKey:@"msgListModel"];
    }
}

+ (instancetype)createQGNotifyDetailController:(id)param {
    QGMessageListModel *model = [param valueForKey:@"model"];

    QGNotifyDetailController *vc = [[QGNotifyDetailController alloc] init];
    vc.msgListModel = model;
    return vc;
}

- (void)viewDidLoad {
    [super viewDidLoad];

    self.title = @"消息详情";
    [self custemLeftDefaultBarButtonItem];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.estimatedRowHeight = 72;
    self.tableView.rowHeight = UITableViewAutomaticDimension;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 2;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = nil;

    if (indexPath.row == 0) {
        QGNotifyDetailTitleCell *titleCell = (QGNotifyDetailTitleCell *) [self getCellFromNibName:@"QGNotifyDetailTitleCell" dequeueTableView:tableView];
        titleCell.titleLbl.text = self.msgListModel.title;
        titleCell.timeLbl.text = self.msgListModel.msgTime;
        cell = titleCell;
    } else if (indexPath.row == 1) {
        QGNotifyDetailContentCell *contentCell = (QGNotifyDetailContentCell *) [self getCellFromNibName:@"QGNotifyDetailContentCell" dequeueTableView:tableView];
        contentCell.content = self.msgListModel.content;
        cell = contentCell;
    }

    cell.selectionStyle = 0;

    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        return 72;
    } else if (indexPath.row == 1) {
        return UITableViewAutomaticDimension;
    }
    return 0.f;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
@end
