//
//  QGMessageCenterVC.m
//  CreditWallet
//
//  Created by 张博 on 17/2/7.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "QGMessageCenterVC.h"
#import "ConfirmDeleteView.h"
#import "QGActivityVC.h"
#import "QGEditBaseCell.h"
#import "QGMessageBottomView.h"
#import "QGMessageDelegateProtocol.h"
#import "QGMessageListModel.h"
#import "QGNotificationVC.h"
#import "QGVerticalAlignedLabel.h"
#import "QGBasicUITool.h"
#import "UIViewController+Gesture.h"
#import "UIView+Extend.h"

@interface QGMessageCenterVC () <QGMessageCellSelectedDelegate, QGMessageBottomViewDelegate>
@property (nonatomic, strong) NSMutableDictionary *unreadCountMdict;
@property (nonatomic, strong) QGMessageBottomView *bottomView;
@property (strong, nonatomic) ConfirmDeleteView *confirmDeleteView;
@property (nonatomic, assign) BOOL editState;

@end

@implementation QGMessageCenterVC

- (BOOL)checkParameters:(NSDictionary *)param {
    return YES;
}

- (void)dealloc {
    self.confirmDeleteView = nil;
}

- (void)viewDidLoad {
    [super viewDidLoad];

    [self setupData];
    [self setupUI];
    [self requestData];
}

#pragma mark - Private
- (void)setupData {
    self.titles = @[ @"通知", @"活动" ];
}

- (void)setupUI {
    [self custemLeftDefaultBarButtonItem];
    self.title = @"消息";
    self.maxAllowedInitialDistance = 20;

    UIButton *editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    editBtn.frame = CGRectMake(0, 20, 40, 40);
    editBtn.titleLabel.font = [UIFont qg_regularFontOfSize:16];
    [editBtn setTitle:@"编辑" forState:UIControlStateNormal];
    [editBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [editBtn addTarget:self action:@selector(doneOrEditClick:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc] initWithCustomView:editBtn];
    self.navigationItem.rightBarButtonItem = rightItem;

    [self resetMenuView];
}

///根据menu个数判断样式
- (void)resetMenuView {
    self.selectIndex = 0;
    self.menuItemWidth = MAINSCREEN_WIDTH / self.titles.count;
    self.titleFontName = [UIFont qg_regularFontOfSize:15].fontName;
    self.titleSizeNormal = 15;
    self.titleSizeSelected = 15;
}

- (void)addMenuItemSepratorLine {
    UIView *line = [[UIView alloc] initWithFrame:CGRectMake(MAINSCREEN_WIDTH / 2 - 0.5, 12, 0.5, 20)];
    line.backgroundColor = [UIColor colorWithHexString:@"DCDCDC"];
    [self.menuView addSubview:line];
    [self.menuView bringSubviewToFront:line];
}

- (void)requestData {
    __weak typeof(self) weakSelf = self;

     //请求未读消息数
    NSString *unreadUrl = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodUnread];
    NSMutableDictionary *noticesParame = [[NSMutableDictionary alloc] initWithCapacity:1];
    [noticesParame setObject:@"all" forKey:@"msgType"];
    
    [[QGTalosNetwork shareManager] GET:unreadUrl parameters:noticesParame success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            [weakSelf.unreadCountMdict setValue:[NSString stringWithFormat:@"%@", dataDic[@"notifyMsgCount"]] forKey:@"business"];
            [weakSelf.unreadCountMdict setValue:@"0" forKey:@"op"];
        }
        [weakSelf reloadData];
        [weakSelf addMenuItemSepratorLine]; //因为重新加载所有子视图，所以需要在调整后添加line
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [weakSelf reloadData];
        [weakSelf addMenuItemSepratorLine]; //因为重新加载所有子视图，所以需要在调整后添加line
    }];
}

#pragma mark - WMPageControllerDataSource
- (CGRect)pageController:(WMPageController *)pageController preferredFrameForContentView:(WMScrollView *)contentView
{
    //导航+菜单
    CGFloat Y = [DeviceAdaptation getNavBarAndStatusBarHeight] + 44;
    //移除tabbar的高度
    CGFloat height = MAINSCREEN_HEIGHT - Y;
    return CGRectMake(0, Y, MAINSCREEN_WIDTH, height);
}

- (CGRect)pageController:(WMPageController *)pageController preferredFrameForMenuView:(WMMenuView *)menuView
{
    //导航+菜单
    CGFloat Y = [DeviceAdaptation getNavBarAndStatusBarHeight];
    return CGRectMake(0, Y, MAINSCREEN_WIDTH, 44);
}

- (NSInteger)numbersOfChildControllersInPageController:(WMPageController *)pageController {
    return self.titles.count;
}

- (NSString *)pageController:(WMPageController *)pageController titleAtIndex:(NSInteger)index {
    if (self.titles.count == 0) {
        return nil;
    }
    return self.titles[index];
}

- (UIViewController *)pageController:(WMPageController *)pageController viewControllerAtIndex:(NSInteger)index {
    UIViewController *vc = nil;
    switch (index) {
        case 0: {
            vc = [[QGNotificationVC alloc] init];
            [(QGNotificationVC *) vc setDelegate:self];
            return vc;
            break;
        }
        case 1: {
            vc = [[QGActivityVC alloc] init];
            [(QGActivityVC *) vc setDelegate:self];
            return vc;
            break;
        }

        default:
            break;
    }
    if (!vc) {
        vc = [[UIViewController alloc] init];
    }

    return vc;
}

- (UIView *)menuView:(WMMenuView *)menu badgeViewAtIndex:(NSInteger)index
{
    if (self.unreadCountMdict.allKeys.count == 0) return nil;

    NSString *key = index == 0 ? @"business" : @"op";

    NSString *badgeStr = [self.unreadCountMdict valueForKey:key];

    if (badgeStr.integerValue == 0) return nil;

    UILabel *redLabel = [self createTabLabelWithBadgeStr:badgeStr];
    return redLabel;
}


- (BOOL)menuView:(WMMenuView *)menu shouldSelesctedIndex:(NSInteger)index
{
    if (self.editState) {
        [self doneOrEditClick:self.navigationItem.rightBarButtonItem.customView];
    }
    return YES;
}


- (void)pageController:(WMPageController *)pageController didEnterViewController:(__kindof UIViewController *)viewController withInfo:(NSDictionary *)info {
    QGEditListBaseVC *vc = (QGEditListBaseVC *) viewController;
    if (vc.dataSource && vc.dataSource.count > 0) {
        if (self.navigationItem.rightBarButtonItem.customView.hidden) {
            self.navigationItem.rightBarButtonItem.customView.hidden = NO;
        }
    } else {
        if (!self.navigationItem.rightBarButtonItem.customView.hidden) {
            self.navigationItem.rightBarButtonItem.customView.hidden = YES;
        }
    }
    [vc reloadNewData];
}

#pragma mark - 处理Tab Label的红点
//根据已读数量处理红点数量
- (void)handleRedPointNumberWithMessageListType:(MessageCenterListType)messageListType readCount:(NSInteger)readCount {

    NSString *key = messageListType == MessageCenterListTypeNotifyMsg ? @"business" : @"op";

    NSInteger unreadCount = [[self.unreadCountMdict valueForKey:key] integerValue];

    if (unreadCount == 0) return;
    if (unreadCount < readCount) return;
    unreadCount = unreadCount - readCount;
    [self.unreadCountMdict setValue:[NSString stringWithFormat:@"%ld", (long) unreadCount] forKey:key];
    [self.menuView updateBadgeViewAtIndex:messageListType];
}


#pragma mark - ButtonClick
- (void)doneOrEditClick:(UIButton *)button {
    QGEditListBaseVC *vc = (QGEditListBaseVC *) self.currentViewController;
    if (vc.dataSource.count == 0 && !self.editState) {
        return;
    }
    button.userInteractionEnabled = NO;
    SEL selector = @selector(setEditState:);
    self.editState = !self.editState;
    if ([self.currentViewController respondsToSelector:@selector(setEditState:)]) {
        IMP imp = [self.currentViewController methodForSelector:selector];
        void (*func)(id, SEL, BOOL) = (void *) imp;
        func(self.currentViewController, selector, self.editState);
    }
    CGFloat indent = (50 + [DeviceAdaptation getBottomSafeAreaHeight]);
    self.bottomView.type = [(QGEditListBaseVC *) self.currentViewController myType];
    if (self.editState) {
        [button setTitle:@"取消" forState:UIControlStateNormal];
        [self.view addSubview:self.bottomView];
        [self.view bringSubviewToFront:self.bottomView];
        [UIView animateWithDuration:0.25
            animations:^{
                self.bottomView.y -= indent;
            }
            completion:^(BOOL finished) {
                button.userInteractionEnabled = YES;
            }];
    } else {
        //tableView处于非编辑状态
        [button setTitle:@"编辑" forState:UIControlStateNormal];

        [UIView animateWithDuration:0.25
            animations:^{
                self.bottomView.y += indent;
            }
            completion:^(BOOL finished) {
                [self.bottomView removeFromSuperview];
                self.bottomView = nil;
                button.userInteractionEnabled = YES;
            }];
    }
    button.enabled = YES;
}

#pragma mark - QGMessageCellSelectedDelegate
- (void)selecedMessageCell:(NSInteger)modelCount messageType:(MessageCenterListType)messageType {
    if (messageType == MessageCenterListTypeActivityMsg) {
        return;
    }
    [self handleRedPointNumberWithMessageListType:messageType readCount:modelCount];
}

- (void)updateSelectBarBtnState:(NSArray *)dataSource selectedData:(NSArray *)selectedData {
    if (self.editState) {
        [self.bottomView setSelectAllBtnSelectedState:([dataSource count] == [selectedData count])];
        BOOL readEnabled = NO;
        BOOL deleteEnabled = NO;
        if (selectedData.count > 0) {
            deleteEnabled = YES;
        }
        for (QGMessageListModel *model in selectedData) {
            if (model.is_ack && ![model.is_ack boolValue]) {
                readEnabled = YES;
                break;
            }
        }
        [self.bottomView updateReadBtnState:readEnabled deleteBtnState:deleteEnabled];
    }
    QGEditListBaseVC *vc = (QGEditListBaseVC *) self.currentViewController;
    if (vc.dataSource && vc.dataSource.count > 0) {
        self.navigationItem.rightBarButtonItem.customView.hidden = NO;
    } else {
        self.navigationItem.rightBarButtonItem.customView.hidden = YES;
    }
}

//全量更新MessageCount
- (void)updateAllMessageCount {
    __weak typeof(self) weakSelf = self;
    //请求未读消息数
    NSString *unreadUrl = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodUnread];
    NSMutableDictionary *noticesParame = [[NSMutableDictionary alloc] initWithCapacity:1];
    [noticesParame setObject:@"all" forKey:@"msgType"];
    
    [[QGTalosNetwork shareManager] GET:unreadUrl parameters:noticesParame success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            [weakSelf.unreadCountMdict setValue:[NSString stringWithFormat:@"%@", dataDic[@"notifyMsgCount"]] forKey:@"business"];
            [weakSelf.unreadCountMdict setValue:@"0" forKey:@"op"];
            [weakSelf.menuView updateBadgeViewAtIndex:0];
            [weakSelf.menuView updateBadgeViewAtIndex:1];
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        
    }];
}

#pragma mark - QGMessageBottomViewDelegate

- (void)messageBottomView:(QGMessageBottomView *)deleteView clickAllselectedButton:(UIButton *)sender {
    QGEditListBaseVC *vc = (QGEditListBaseVC *) self.currentViewController;
    [vc allDataSelected];
}

- (void)messageBottomView:(QGMessageBottomView *)deleteView clickReadButton:(UIButton *)sender {
    QGEditListBaseVC *vc = (QGEditListBaseVC *) self.currentViewController;
    NSMutableArray *idArray = [NSMutableArray array];
    [vc.dataSource enumerateObjectsUsingBlock:^(id _Nonnull obj, NSUInteger idx, BOOL *_Nonnull stop) {
        QGMessageListModel *model = vc.dataSource[idx];
        if (model.selectedState) {
            if (model.is_ack && ![model.is_ack boolValue]) {
                model.is_ack = @YES;
                if (model.infoId) {
                    [idArray addObject:@([model.infoId integerValue])];
                }
                NSIndexPath *indexPath = [NSIndexPath indexPathForRow:idx inSection:0];
                QGEditBaseCell *cell = [vc.tableView cellForRowAtIndexPath:indexPath];
                [cell updateModel:model];
            }
        }
    }];
    [vc selectedDataCancel];
    //置为已读
    NSString * urlString = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodMarkReadOrDel];
    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
    [infoDic setObject:idArray forKey:@"msgIdList"];
    //标记类型：1：标记已读 2：标记删除
    [infoDic setObject:@(1) forKey:@"markType"];
    [[QGTalosNetwork shareManager] POST:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [self selecedMessageCell:idArray.count messageType:MessageCenterListTypeNotifyMsg];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        
    }];
}

- (void)messageBottomView:(QGMessageBottomView *)deleteView clickDeleteButton:(UIButton *)sender {
    QGEditListBaseVC *vc = (QGEditListBaseVC *) self.currentViewController;
    NSMutableArray *selectedData = vc.selectedData;
    //删除按钮点击事件
    if (selectedData.count == 0) {
        [QGHUDManager showHud:@"没选中消息不能删除哦~"];
        return;
    }
    NSMutableArray *idArray = [NSMutableArray array];
    NSMutableArray *indexPathArray = [NSMutableArray array];
    __block NSInteger readNum = 0;
    [vc.dataSource enumerateObjectsUsingBlock:^(id _Nonnull obj, NSUInteger idx, BOOL *_Nonnull stop) {
        QGMessageListModel *model = vc.dataSource[idx];
        if (model.selectedState) {
            if (model.infoId) {
                [idArray addObject:@([model.infoId integerValue])];
            }
            NSIndexPath *indexPath = [NSIndexPath indexPathForRow:idx inSection:0];
            [indexPathArray addObject:indexPath];
            if (model.is_ack && ![model.is_ack boolValue]) {
                readNum++;
            }
        }

    }];

    __weak typeof(self) weakSelf = self;
    self.confirmDeleteView.deleteBlock = ^() {
        [QGHUDManager showHud:nil];
        __strong __typeof(weakSelf) strongSelf = weakSelf;
        MessageCenterListType type = MessageCenterListTypeNotifyMsg;
        //删除数据
        NSString * urlString = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodMarkReadOrDel];
        NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
        [infoDic setObject:idArray forKey:@"msgIdList"];
        //标记类型：1：标记已读 2：标记删除
        [infoDic setObject:@(2) forKey:@"markType"];
        [[QGTalosNetwork shareManager] POST:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
            [QGHUDManager hideHud];
            if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
                for (QGMessageListModel *aModel in vc.selectedData) {
                    [vc.dataSource removeObject:aModel];
                }
                [vc.tableView deleteRowsAtIndexPaths:indexPathArray withRowAnimation:UITableViewRowAnimationFade];
                [strongSelf.bottomView updateReadBtnState:NO deleteBtnState:NO];
                [strongSelf doneOrEditClick:strongSelf.navigationItem.rightBarButtonItem.customView];
                [strongSelf selecedMessageCell:readNum messageType:type];
                [strongSelf.confirmDeleteView hide];
                [vc loadNewData];
            }
            else
            {
                [QGHUDManager showHudWithError:responseObject];
            }
        } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
            [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
        }];
    };

    //show
    [self.confirmDeleteView showWithCount:selectedData.count];
}

#pragma mark - Getter
- (QGMessageBottomView *)bottomView {
    if (!_bottomView) {
        _bottomView = [[QGMessageBottomView alloc] initWithFrame:CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, 50 + [DeviceAdaptation getBottomSafeAreaHeight])];
        _bottomView.delegate = self;
    }
    return _bottomView;
}

- (ConfirmDeleteView *)confirmDeleteView {
    if (!_confirmDeleteView) {
        _confirmDeleteView = [[ConfirmDeleteView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT)];
    }

    return _confirmDeleteView;
}

- (NSMutableDictionary *)unreadCountMdict {
    if (!_unreadCountMdict) {
        _unreadCountMdict = [NSMutableDictionary dictionary];
    }
    return _unreadCountMdict;
}

- (UILabel *)createTabLabelWithBadgeStr:(NSString *)badgeStr
{
    CGFloat width = 14;
    CGFloat height = width;
    CGFloat cornerRadius = height/2.0;
    
    //大于99特殊处理宽度和圆角
    if (badgeStr.integerValue > 99) {
        badgeStr = @"99+";
        width += 8;
    }
    
    CGFloat x = self.menuItemWidth / 2 + 15;
    CGFloat y = 44 / 2 - 15;
    UILabel *newLabel = [[UILabel alloc] initWithFrame:CGRectMake(x, y, width, height)];
    newLabel.font = [UIFont qg_regularFontOfSize:9];
    newLabel.textColor = [UIColor colorWithHexString:@"FFFFFF"];
    newLabel.backgroundColor = [UIColor mainThemeColor];
    newLabel.textAlignment = NSTextAlignmentCenter;
    newLabel.text = badgeStr;
    newLabel.layer.cornerRadius = cornerRadius;
    newLabel.clipsToBounds = YES;
    
    return newLabel;
}

@end
