//
//  QGEditListBaseVC.m
//  CreditWallet
//
//  Created by harry on 02/01/2018.
//  Copyright © 2018 QuantGroup. All rights reserved.
//

#import "QGEditListBaseVC.h"
#import "Mediator.h"
#import "QGApplicationOpenURL.h"
#import "QGMessageListModel.h"
#import "QGNoMessageDataView.h"
#import "QGNotificationCell.h"
#import "QGNotifyDetailController.h"
#import "QGRefreshNomalHeader.h"
#import "DeviceAdaptation.h"
#import "MJRefresh.h"
#import "UIView+Extend.h"
#import "SystemManager.h"

#import "CWWebViewController.h"


@interface QGEditListBaseVC () <UITableViewDelegate, UITableViewDataSource>

@end

@implementation QGEditListBaseVC

- (void)dealloc {
    self.delegate = nil;
    //安全处理
    if (_tableView) {
        self.tableView.delegate = nil;
        self.tableView.dataSource = nil;
    }
}

- (instancetype)init {
    self = [super init];
    if (self) {
        _dataSource = [NSMutableArray array];
        _selectedData = [NSMutableArray array];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    CGFloat navStatusHeight = [DeviceAdaptation getNavBarAndStatusBarHeight];
    UITableView *tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - navStatusHeight - 44.f) style:UITableViewStylePlain];
    tableView.delegate = self;
    tableView.dataSource = self;
    tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    tableView.allowsSelectionDuringEditing = YES;
    tableView.allowsMultipleSelectionDuringEditing = YES;
    self.tableView = tableView;
    [self.view addSubview:tableView];
    UIColor *color = [UIColor whiteColor];
    if ([self myType] == MessageCenterListTypeActivityMsg) {
        color = [UIColor colorWithHexString:@"f6f6f6"];
    } else {
        color = [UIColor whiteColor];
    }
    tableView.backgroundColor = color;
    [self addTableViewCellStyle];
    [self addMJRefreshGifHeaderForCurrent];
    [self loadNewData];
    // Do any additional setup after loading the view.
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - NeedOverWrite

- (void)addTableViewCellStyle {
}

- (void)loadData:(BOOL)needNew {
}

- (void)loadNewData {
    [QGHUDManager showHud:nil];
    if (self.dataSource.count == 0) {
        self.tableView.mj_footer = nil;
    }
    [self loadData:YES];
}

- (void)reloadNewData {
    if (self.dataSource.count == 0 && !self.tableView.mj_header) {
        [QGHUDManager showHud:nil];
        [self addMJRefreshGifHeaderForCurrent];
        if (self.dataSource.count == 0) {
            self.tableView.mj_footer = nil;
        }
        [self loadData:YES];
    }
}

- (MessageCenterListType)myType {
    return MessageCenterListTypeNotifyMsg;
}

#pragma mark - updateMethod

- (void)updateList:(NSArray *)modelList needNew:(BOOL)needNew hasMore:(BOOL)hasMore failure:(BOOL)isFailure failureResponse:(id)responseObject {
    [QGHUDManager hideHud];
    if (isFailure) {
        if (needNew) {
            if (!self.dataSource || [self.dataSource count] == 0) {
                self.tableView.mj_header = nil;
                //无数据时设置无数据背景view
                QGNoMessageDataView *noDataView = [[QGNoMessageDataView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, CGRectGetHeight(self.tableView.frame))];
                [noDataView addTarget:self action:@selector(reloadNewData) forControlEvents:UIControlEventTouchUpInside];
                NSString *message = @"";
                if (responseObject && [responseObject isKindOfClass:[NSDictionary class]]) {
                    message = [responseObject objectForKey:@"message"];
                }
                if (message && [message isKindOfClass:[NSString class]] && message.length > 0) {
                    noDataView.text = message;
                }
                UIColor *color = [UIColor whiteColor];
                if ([self myType] == MessageCenterListTypeActivityMsg) {
                    color = [UIColor colorWithHexString:@"f6f6f6"];
                } else {
                    color = [UIColor whiteColor];
                }
                noDataView.themeBgColor = color;
                self.tableView.backgroundView = noDataView;
                self.tableView.mj_footer = nil;
            }

            [self.tableView.mj_header endRefreshing];
        } else {
            if (!self.tableView.mj_footer) {
                [self addMJRefreshGifFooterForCurrent];
            }
            [self.tableView.mj_footer endRefreshing];
            [(MJRefreshAutoStateFooter *) self.tableView.mj_footer setTitle:@"加载失败，点击重新加载" forState:MJRefreshStateIdle];
        }
    } else {
        if (modelList && modelList.count > 0) {
            if (needNew) {
                //下拉刷新时清空旧的数据，然后添加新的数据
                [self.dataSource removeAllObjects];
                [self.dataSource addObjectsFromArray:modelList];
                
                self.tableView.backgroundView = nil;
                [self.tableView.mj_header endRefreshing];
                [self.tableView reloadData];
                if (!self.tableView.mj_footer) {
                    [self addMJRefreshGifFooterForCurrent];
                }
                if (hasMore) {
                    [self.tableView.mj_footer endRefreshing];
                    [(MJRefreshAutoStateFooter *) self.tableView.mj_footer setTitle:@"点击或上拉加载更多" forState:MJRefreshStateIdle];

                } else {
                    //没有更多
                    [self.tableView.mj_footer endRefreshingWithNoMoreData];
                }

            } else {
                if (!self.tableView.mj_footer) {
                    [self addMJRefreshGifFooterForCurrent];
                }
                if (!hasMore) {
                    //没有更多
                    [self.tableView.mj_footer endRefreshingWithNoMoreData];
                } else {
                    [self.tableView.mj_footer endRefreshing];
                    [(MJRefreshAutoStateFooter *) self.tableView.mj_footer setTitle:@"点击或上拉加载更多" forState:MJRefreshStateIdle];
                }
                
                [self.dataSource addObjectsFromArray:modelList];
                
                /*  修改indexPath与数据插入不一致的bug
                 NSMutableArray *indexPathsMarr = [NSMutableArray array];
                __block NSInteger row = self.dataSource.count - 1;
                [modelList enumerateObjectsUsingBlock:^(id _Nonnull obj, NSUInteger idx, BOOL *_Nonnull stop) {
                    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:(++row) inSection:0];
                    [indexPathsMarr addObject:indexPath];
                }];
                dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                    [self.tableView insertRowsAtIndexPaths:indexPathsMarr withRowAnimation:UITableViewRowAnimationBottom];
                });
                 */
                [self.tableView reloadData];
            }
            if ([self.delegate respondsToSelector:@selector(updateAllMessageCount)]) {
                [self.delegate updateAllMessageCount];
            }
        } else {
            if (needNew) {
                if (!self.dataSource || [self.dataSource count] == 0) {
                    //无数据时设置无数据背景view
                    self.tableView.mj_header = nil;
                    UIColor *color = [UIColor whiteColor];
                    if ([self myType] == MessageCenterListTypeActivityMsg) {
                        color = [UIColor colorWithHexString:@"f6f6f6"];
                    } else {
                        color = [UIColor whiteColor];
                    }
                    QGNoMessageDataView *noDataView = [[QGNoMessageDataView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, CGRectGetHeight(self.tableView.frame))];
                    [noDataView addTarget:self action:@selector(reloadNewData) forControlEvents:UIControlEventTouchUpInside];
                    noDataView.themeBgColor = color;
                    self.tableView.backgroundView = noDataView;
                    self.tableView.mj_footer = nil;
                }
                [self.tableView.mj_header endRefreshing];
                if ([self.delegate respondsToSelector:@selector(updateAllMessageCount)]) {
                    [self.delegate updateAllMessageCount];
                }
            } else {

                if (!self.tableView.mj_footer) {
                    [self addMJRefreshGifFooterForCurrent];
                }
                if (!hasMore) {
                    //没有更多
                    [self.tableView.mj_footer endRefreshingWithNoMoreData];
                } else {
                    [self.tableView.mj_footer endRefreshing];
                    [(MJRefreshAutoStateFooter *) self.tableView.mj_footer setTitle:@"点击或上拉加载更多" forState:MJRefreshStateIdle];
                }
            }
        }
    }
    //修改底部“全选”按钮的选中状态
    if ([self.delegate respondsToSelector:@selector(updateSelectBarBtnState:selectedData:)]) {
        [self.delegate updateSelectBarBtnState:self.dataSource selectedData:self.selectedData];
    }
}

- (void)updateSelectedData:(MessageCenterListType)type indexPath:(NSIndexPath *)indexPath {
    if (self.dataSource && self.dataSource.count > indexPath.row) {
        QGMessageListModel *model = self.dataSource[indexPath.row];
        //tableView是否处于编辑状态
        if (self.tableView.isEditing) {
            //判断当前cell的选中状态
            if (model.selectedState) {
                [self.tableView deselectRowAtIndexPath:indexPath animated:YES];
                [self.selectedData removeObject:model];
            } else {
                [self.tableView selectRowAtIndexPath:indexPath animated:YES scrollPosition:UITableViewScrollPositionNone];
                [self.selectedData addObject:model];
            }
            model.selectedState = !model.selectedState;
            QGNotificationCell *selectedCell = [self.tableView cellForRowAtIndexPath:indexPath];
            [selectedCell updateModel:model];
        } else {
            if (type == MessageCenterListTypeNotifyMsg) {
                if (model.is_ack && ![model.is_ack boolValue]) {
                    model.is_ack = @YES; //先在内存做临时处理，等数据返回再更新
                    model.messageType = @(type);
                    QGNotificationCell *selectedCell = [self.tableView cellForRowAtIndexPath:indexPath];
                    [selectedCell updateModel:model];

                    NSMutableArray *idArray = [NSMutableArray array];
                    if (model.infoId) {
                        [idArray addObject:@([model.infoId integerValue])];
                    }
                    //置为已读
                    NSString * urlString = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodMarkReadOrDel];
                    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
                    [infoDic setObject:idArray forKey:@"msgIdList"];
                    //标记类型：1：标记已读 2：标记删除
                    [infoDic setObject:@(1) forKey:@"markType"];
                    [[QGTalosNetwork shareManager] POST:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
                        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
                            if ([self.delegate respondsToSelector:@selector(selecedMessageCell:messageType:)]) {
                                [self.delegate selecedMessageCell:idArray.count messageType:type];
                            }
                        }
                    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
                        
                    }];
                    
                }
                if ([DeviceAdaptation canClick]) {
                    if (model.nav_url && model.nav_url.length > 0) {
                        NSString *urlStr = model.nav_url;
                        [QGApplicationOpenURL handleAllSupportUrl:urlStr];
                    } else {
                        NSMutableDictionary *mdict = [NSMutableDictionary dictionaryWithCapacity:1];
                        [mdict setValue:model forKey:@"msgListModel"];
                        //修改冲突
                        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGNotifyDetailController] parameters:mdict handlerBlock:nil];
                    }
                }

            } else {
                if (!model.navExpire || ![model.navExpire boolValue]) {
                    NSString *urlStr = model.nav_url;
                     [QGApplicationOpenURL handleAllSupportUrl:urlStr];
                }
            }
        }
    }
    if (self.tableView.isEditing) {
        //修改底部“全选”按钮的选中状态
        if ([self.delegate respondsToSelector:@selector(updateSelectBarBtnState:selectedData:)]) {
            [self.delegate updateSelectBarBtnState:self.dataSource selectedData:self.selectedData];
        }
    }
}

- (void)allDataSelected {
    BOOL selected = NO;
    if ([self.dataSource count] != self.selectedData.count) {
        [self.selectedData removeAllObjects];
        [self.selectedData addObjectsFromArray:self.dataSource];
        selected = YES;
    } else {
        [self.selectedData removeAllObjects];
    }
    [self.dataSource enumerateObjectsUsingBlock:^(id _Nonnull obj, NSUInteger idx, BOOL *_Nonnull stop) {
        QGMessageListModel *model = self.dataSource[idx];
        model.selectedState = selected;
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:idx inSection:0];
        if (selected) {
            [self.tableView selectRowAtIndexPath:indexPath animated:YES scrollPosition:UITableViewScrollPositionNone];
        } else {
            [self.tableView deselectRowAtIndexPath:indexPath animated:YES];
        }

    }];
    //修改底部“全选”按钮的选中状态
    if ([self.delegate respondsToSelector:@selector(updateSelectBarBtnState:selectedData:)]) {
        [self.delegate updateSelectBarBtnState:self.dataSource selectedData:self.selectedData];
    }
}

- (void)selectedDataCancel {
    if (self.selectedData && self.selectedData.count > 0) {
        [self.dataSource enumerateObjectsUsingBlock:^(id _Nonnull obj, NSUInteger idx, BOOL *_Nonnull stop) {
            QGMessageListModel *model = self.dataSource[idx];
            if (model.selectedState) {
                NSIndexPath *indexPath = [NSIndexPath indexPathForRow:idx inSection:0];
                [self.tableView deselectRowAtIndexPath:indexPath animated:YES];
                model.selectedState = NO;
            }
        }];
        [self.selectedData removeAllObjects];
        //修改底部“全选”按钮的选中状态
        if ([self.delegate respondsToSelector:@selector(updateSelectBarBtnState:selectedData:)]) {
            [self.delegate updateSelectBarBtnState:self.dataSource selectedData:self.selectedData];
        }
    }
}

#pragma mark - Prviate
- (void)setEditState:(BOOL)editState {
    if (_editState != editState) {
        _editState = editState;
        [self.tableView setEditing:editState animated:YES];
        CGFloat indent = (50 + [DeviceAdaptation getBottomSafeAreaHeight]);
        if (editState) {
            self.tableView.bounces = NO;
            self.tableView.height -= indent;
        } else {
            self.tableView.bounces = YES;
            self.tableView.height += indent;
        }
    }
}

//下拉刷新
- (void)addMJRefreshGifHeaderForCurrent {
    __weak __typeof(self) weakSelf = self;
    QGRefreshNomalHeader *header = [QGRefreshNomalHeader headerWithRefreshingBlock:^{
        __strong __typeof(weakSelf) strongSelf = weakSelf;
        [strongSelf loadData:YES];
    }];
    header.lastUpdatedTimeLabel.hidden = YES;
    self.tableView.mj_header = header;
    UIColor *color = [UIColor whiteColor];
    if ([self myType] == MessageCenterListTypeActivityMsg) {
        color = [UIColor colorWithHexString:@"f6f6f6"];
    } else {
        color = [UIColor whiteColor];
    }
    header.themeBgColor = color;
}

//上拉加载
- (void)addMJRefreshGifFooterForCurrent {
    __weak __typeof(self) weakSelf = self;
    MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        __strong __typeof(weakSelf) strongSelf = weakSelf;
        [strongSelf loadData:NO];
    }];

    self.tableView.mj_footer = footer;
    UIColor *color = [UIColor whiteColor];
    if ([self myType] == MessageCenterListTypeActivityMsg) {
        color = [UIColor colorWithHexString:@"f6f6f6"];
    } else {
        color = [UIColor whiteColor];
    }
    self.tableView.mj_footer.backgroundColor = color;
}

#pragma mark - QGEditBaseCellSelectedDelegate

- (void)didSelectedEditCell:(id)cell {
    //获取被选中cell的indexPath
    NSIndexPath *selIndexPath = [self.tableView indexPathForCell:cell];
    //手动调用tableView的didSelectRowAtIndexPath方法
    [self tableView:self.tableView didSelectRowAtIndexPath:selIndexPath];
    //    [self updateSelectedData:[self myType] indexPath:selIndexPath];
}

#pragma mark - UITableViewDelegate

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataSource.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    //cell
    return [UITableViewCell new];
}

- (void)tableView:(UITableView *)tableView willDisplayCell:(UITableViewCell *)cell forRowAtIndexPath:(NSIndexPath *)indexPath {
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [self updateSelectedData:[self myType] indexPath:indexPath];
}

- (void)tableView:(UITableView *)tableView didDeselectRowAtIndexPath:(NSIndexPath *)indexPath {
}

- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    return YES;
}

- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath {
    return UITableViewCellEditingStyleNone;
}

- (NSInteger)tableView:(UITableView *)tableView indentationLevelForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 2;
}

@end
