//
//  QGActivityVC.m
//  CreditWallet
//
//  Created by harry on 28/12/2017.
//  Copyright © 2017 QuantGroup. All rights reserved.
//

#import "QGActivityVC.h"
#import "QGRefreshNomalHeader.h"
#import "QGNoMessageDataView.h"
#import "QGMessageListModel.h"
#import "QGActivityCell.h"
#import "UIFont+QGFont.h"


static NSString * const kQGActivityCellIdentify = @"kQGActivityCellIdentify";

@interface QGActivityVC ()


@end

@implementation QGActivityVC

- (void)dealloc{

}



- (void)viewDidLoad {
    [super viewDidLoad];
    UIView *headerView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 5.f)];
    headerView.backgroundColor = [UIColor colorWithHexString:@"f6f6f6"];
    self.tableView.tableHeaderView = headerView;
    // Do any additional setup after loading the view.
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)addTableViewCellStyle{
    self.tableView.rowHeight = 39.f+206*Screen_Scaling;
    [self.tableView registerClass:[QGActivityCell class] forCellReuseIdentifier:kQGActivityCellIdentify];
}

- (MessageCenterListType)myType{
    return MessageCenterListTypeActivityMsg;
}

- (void)loadData:(BOOL)needNew{
    
    //上一条消息id，只有上拉刷新时需要
    NSString * lastMsgId = nil;
    //下拉刷新
    if (needNew) {
        
    }
    //上拉刷新
    else
    {
        lastMsgId = [self.dataSource.lastObject infoId];
    }
    
    NSString * urlString = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodStationLetterList];
    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
    //站内信类型 0：通知  1：活动
    [infoDic setObject:@"1" forKey:@"msgType"];
    [infoDic setObject:@(10) forKey:@"pageSize"];
    
    //lastMsgId只有上拉加载时传
    if (![NSString isEmpty:lastMsgId]) {
        [infoDic setObject:lastMsgId forKey:@"lastMsgId"];
    }
    
    [[QGTalosNetwork shareManager] POST:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        //业务请求成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            
            NSDictionary * dataDic = responseObject[@"data"];
            NSDictionary * pageInfoDic = dataDic[@"pageInfo"];
            //后台返回是否有更多页
            BOOL hasMore = [pageInfoDic[@"hasNext"] boolValue];
            
            NSArray *notifyMsgList = dataDic[@"notifyMsgList"];
            NSMutableArray *marr = [NSMutableArray arrayWithCapacity:0];
            for (NSDictionary *tempDict in notifyMsgList) {
                QGMessageListModel *model = [[QGMessageListModel alloc] initWithDic:tempDict];
                [marr addObject:model];
            }
            
             [self updateList:marr needNew:needNew hasMore:hasMore failure:NO failureResponse:nil];
        }
        //业务请求失败
        else
        {
            [self updateList:nil needNew:needNew hasMore:NO failure:YES failureResponse:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [self updateList:nil needNew:needNew hasMore:NO failure:YES failureResponse:error];
    }];
    
}

#pragma mark- Prviate



#pragma mark- UITableViewDelegate



- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    //cell
    QGActivityCell *cell = [tableView dequeueReusableCellWithIdentifier:kQGActivityCellIdentify forIndexPath:indexPath];
    cell.selectedBackgroundView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 39.f+206*Screen_Scaling)];
    if (self.dataSource && self.dataSource.count > indexPath.row) {
        cell.delegate = self;
        QGMessageListModel *model = self.dataSource[indexPath.row];
        [cell updateModel:model];
    }
    
    return cell;
}




@end
