//
//  QGSafeCenterViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/26.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGSafeCenterViewController.h"
#import "QGMineCommonTitleTableViewCell.h"
#import "QGMineModel.h"
#import "QGBasicUITool.h"
#import "SystemManager.h"
#import "QGUserCenterRequestApi.h"
#import "QGBaiChuanManager.h"

#import "QGAlertView.h"
#import "QGMallRequestApi.h"

#import "QGThirdPlatformService.h"
#import "QGLoginRequestApi.h"

#import "QGSafeBindSmsVerifyViewController.h"


typedef NS_ENUM(NSInteger,QGAuthStatus){
    QGAuthStatusUnknown,   /// 未知授权状态
    QGAuthStatusAuthed,    /// 已授权
    QGAuthStatusUnAuth     /// 未授权
};

@interface QGSafeCenterViewController ()
///列表模型数组
@property (nonatomic, strong)NSMutableArray *dataArray;

/// 修改交易密码
@property (nonatomic, strong) NSString * resetDealPwdUrl;

/// 微信授权状态
@property (nonatomic, assign) QGAuthStatus wxAuthStatus;


@end

@implementation QGSafeCenterViewController
-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"安全中心";
    [self setIsBelowNavBar:NO];
    [self setNavBarBottomLineHidden:YES];
    [self custemLeftDefaultBarButtonItem];
    
    [self.tableView registerClass:[QGMineCommonTitleTableViewCell class] forCellReuseIdentifier:NSStringFromClass([QGMineCommonTitleTableViewCell class])];
    [self initData];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(taobaoAuthChanged) name:AlimamaAuthSuccessNotification object:nil];
    
    self.tableView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    
    [self requestStatusShowhud:NO];
}


/// 查询当前授权状态
- (void)requestStatusShowhud:(BOOL)show
{
    if (show) {
        [QGHUDManager showHud:nil];
    }
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    // [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodQueryStatus]
    //@"http://yapi.quantgroups.com/mock/305/vcc/external/login/auth_status"
    [networking GET:[QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodQueryStatus] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            NSArray *authList = data[@"authStatusList"];
            for (NSDictionary *dic in authList) {
                if ([dic[@"authType"] integerValue] == 1) {
                    bool auth =  [dic[@"hadAuth"] boolValue];
                    self.wxAuthStatus = auth ? QGAuthStatusAuthed : QGAuthStatusUnAuth;
                    break;
                }
            }
            /// 刷新数据
            [self initData];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager hideHud];
    }];
}

- (void)taobaoAuthChanged
{
    [self initData];
}

#pragma mark - TableView Delegate & DataSource

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataArray.count;
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 61;
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    QGMineCommonTitleTableViewCell *cell = (QGMineCommonTitleTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGMineCommonTitleTableViewCell class]) dequeueTableView:tableView];
    cell.model = self.dataArray[indexPath.row];
    return cell;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    QGMineModel *model = self.dataArray[indexPath.row];
    if (model.itemClickBlock) {
        model.itemClickBlock(model);
    }
}
//创建模型数组准备数据
-(void)initData
{
 
    if (self.dataArray.count) {
        [self.dataArray removeAllObjects];
    }
    @weakify(self);
    //修改交易密码
    QGMineModel *transactionPassword = [[QGMineModel alloc]initWithTitle:@"修改交易密码" subtitle:nil clickAction:^(QGMineModel *model) {
        @strongify(self);
        //跳转修改交易密码页面
        [self jumpChangePasswordPage];
    }];
    [self.dataArray addObject:transactionPassword];
    
    //修改登录密码
    QGMineModel *loginPassword = [[QGMineModel alloc] initWithTitle:@"修改登录密码" subtitle:nil clickAction:^(QGMineModel *model) {
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGMineResetLoginPasswordViewController] parameters:nil handlerBlock:^(NSString *tag, NSDictionary *parameters) {
            @strongify(self);
            [self.navigationController popToRootViewControllerAnimated:NO];
            //修改密码完成后进入登录页面
            [self showLoginViewControllerCompletion:^{
                [[SystemManager shareInstance].tabbarController jumpCard];
            }];
        }];
    }];
    [self.dataArray addObject:loginPassword];
    
    
    NSString *wxSubTitle = @"";
    if (self.wxAuthStatus == QGAuthStatusAuthed) {
        wxSubTitle = @"已授权";
    }else{
        wxSubTitle = @"未授权";
    }
    
    QGMineModel *wxAuthModel = [[QGMineModel alloc]initWithTitle:@"微信授权" subtitle:wxSubTitle clickAction:^(QGMineModel *model) {
        @strongify(self);
        /// 已授权,点击解除授权
        if (self.wxAuthStatus == QGAuthStatusAuthed) {
            [self unBindWxAuth];
        }
        /// 未授权,点击授权
        else if(self.wxAuthStatus == QGAuthStatusUnAuth){
            [self bindWxAuth];
        }
        /// 不知道授权状态,点击查询状态
        else{
            // 查询授权状态
            [self requestStatusShowhud:YES];
        }
    }];
    [self.dataArray addObject:wxAuthModel];
    
    /// 淘宝授权
    bool alimamaAuth = QGUserInfo.sharedUserInfo.alimamaAuth;
    QGMineModel *tbAuthModel = [[QGMineModel alloc]initWithTitle:@"淘宝授权" subtitle:alimamaAuth ? @"已授权":@"未授权" clickAction:^(QGMineModel *model) {
        @strongify(self);
        if (alimamaAuth) {
            [self cancleTaoBaoAuth];
        }else{
            [[QGBaiChuanManager shareInstance] authAllAuthoritiesWithController:self.navigationController];
        }
    }];
    [self.dataArray addObject:tbAuthModel];
    
    
    [self.tableView reloadData];
    
}

#pragma mark - 微信授权相关

- (void)bindWxAuth
{
    @weakify(self);
    [[QGThirdPlatformService shareInstance] wxAuthWithSuccess:^(QGWechatLoginInfoModel *infoModel) {
        @strongify(self);
        /// 查询授权状态
        [self queryAuthStatusWithOpenId:infoModel.unionid complete:^{
            QGSafeBindSmsVerifyViewController *vc = [[QGSafeBindSmsVerifyViewController alloc]init];
            vc.wxModel = infoModel;
            /// 绑定完成
            vc.bindSuccessBlock = ^(BOOL Success) {
                self.wxAuthStatus = QGAuthStatusAuthed;
                [self initData];
            };
            [self.navigationController pushViewController:vc animated:YES];
        }];
    }];
}

///解绑微信
- (void)unBindWxAuth
{
    
    QGAlertView *alert = [[QGAlertView alloc]initWithTitle:nil message:@"解绑微信号后，将无法继续使用它登录此真享生活账号哦~" cancelButtonTitle:@"取消" sureButtonTitle:@"确认" clickBlock:^(NSInteger index) {
        if (index == 1) {
            [self requestUnBindWxAuth];
        }
    }];
    [alert showInView:self.view];
    
   
}

- (void)requestUnBindWxAuth
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
      // [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodUnBindWeChat]
    //@"http://yapi.quantgroups.com/mock/305/vcc/external/login/weChat/unbind"
    [QGHUDManager showHud:@""];
    [networking GET:[QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodUnBindWeChat] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
       if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
           /// 刷新页面
           self.wxAuthStatus = QGAuthStatusUnAuth;
           [self initData];
           
       }else{
           NSString *msg = responseObject[@"msg"]?responseObject[@"msg"]:@"解除授权错误";
           [QGHUDManager showHud:msg];
       }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
       [QGHUDManager showHud:@"网络错误,请稍后再试"];
    }];
}


/// 查询当前的微信id是否可以被绑定
/// @param unionId 唯一id
/// @param completeBlock 可用完成回调
- (void)queryAuthStatusWithOpenId:(NSString *)unionId complete:(void(^)(void))completeBlock
{
    if (unionId == nil) return;
    
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    
    [param setObject:unionId forKey:@"authId"];
    //  1:微信 2：apple 3：淘宝 4：百川
    [param setObject:@(1) forKey:@"authType"];
    
    [QGHUDManager showHud:nil];
   // [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodBindAvailable]
    //@"http://yapi.quantgroups.com/mock/305/vcc/external/login/auth_status/authId"
    [networking GET:[QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodBindAvailable] parameters:param success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            if (completeBlock) {
                completeBlock();
            }
        }else{
            NSString *businessCode = responseObject[@"businessCode"];
            /// 已被绑定,不可用
            if ([businessCode isEqualToString:@"1012"]) {
                QGAlertView *alert = [[QGAlertView alloc]initWithTitle:nil message:@"该微信已绑定其他真享生活账号，无法进行授权！" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:NULL];
                [alert showInView:self.view];
            }else{
                NSString *msg = responseObject[@"msg"] ? responseObject[@"msg"]:@"授权错误";
                [QGHUDManager showHud:msg];
            }
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:@"网络错误,请稍后再试"];
    }];
}

/// 去短信验证绑定
- (void)toSMSverify
{
    
}


#pragma mark - 百川授权相关

- (void)cancleTaoBaoAuth
{
    QGAlertView *alert = [[QGAlertView alloc] initWithTitle:nil message:@"确认取消淘宝授权？取消后将无法继续获得返现哦～" cancelButtonTitle:@"取消" sureButtonTitle:@"确认" clickBlock:^(NSInteger index) {
        if (index == 1) {
            /// 请求后台取消授权
            [self notifyServerCancleTaobaoAuth];
        }
    }];
    [alert showInView:self.view];
}

/// 通知后台取消淘宝授权
- (void)notifyServerCancleTaobaoAuth
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    [QGHUDManager showHud:nil];
    [networking POST:[QGMallRequestApi urlWithIndex:QGMallRequestServerMethodUnBindTaoBaoAuth] parameters:nil success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [QGBaiChuanManager.shareInstance unAuthLogin];
            [self initData];
            [QGHUDManager showHud:@"已解除授权"];
        }else{
            NSString *msg = responseObject[@"msg"];
            [QGHUDManager showHud:msg ? msg :@"解除授权失败"];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:@"网络失败"];
    }];
}


-(NSMutableArray *)dataArray
{
    if (!_dataArray) {
        _dataArray = [[NSMutableArray alloc]init];
    }
    return _dataArray;
}

///跳转修改交易密码页面
- (void)jumpChangePasswordPage
{
    if (![NSString isEmpty:self.resetDealPwdUrl]) {
        [self navigationToWeb:self.resetDealPwdUrl];
        return;
    }
    
    NSString * urlString = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodRestPwdUrl];
    [QGHUDManager showHud:nil];
    @weakify(self);
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
         @strongify(self);
        [QGHUDManager hideHud];
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSString * resetPwdUrl = responseObject[@"data"][@"resetPwdUrl"];
            if (![NSString isEmpty:resetPwdUrl]) {
                self.resetDealPwdUrl = resetPwdUrl;
                [self jumpChangePasswordPage];
            }
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMsg = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMsg];
    }];
}


- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

@end
