//
//  QGSafeBindSmsVerifyViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/5/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGSafeBindSmsVerifyViewController.h"

#import "QGGradientShadowButton.h"

#import "QGSendMessageCodeManger.h"

#import "QGCountDown.h"

#import "QGLoginRequestApi.h"

@interface QGSafeBindSmsVerifyViewController ()

@property (nonatomic, copy) NSString *phone ;

@property (nonatomic, strong) QGGradientShadowButton *commitBtn ;

///倒计时剩余时间
@property (nonatomic, assign)NSInteger residueTime;

///自定义定时器
@property (nonatomic, strong)QGCountDown *countDownTimer;

///获取短信验证码管理类
@property (nonatomic, strong)QGSendMessageCodeManger *sendVerifyCodeManger;

/// 获取验证码
@property (nonatomic, strong) UIButton *vCodeBtn ;

/// 验证码
@property (nonatomic, strong) UITextField *vCodeTF ;

@end

@implementation QGSafeBindSmsVerifyViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self custemLeftDefaultBarButtonItem];
    self.title = @"绑定微信";
    [self setNavBarBottomLineHidden:YES];
    self.view.backgroundColor = UIColor.whiteColor;
    
    
    QGUserInfo *userInfo = QGUserInfo.sharedUserInfo;
    if (userInfo.isLogin) {
        self.phone = userInfo.userName;
    }
    
    [self initNomalUI];
    
    //初始化定时器
    self.residueTime = 60;
    self.countDownTimer = [[QGCountDown alloc]init];
    
    //初始化发送验证码管理类
    self.sendVerifyCodeManger = [[QGSendMessageCodeManger alloc] init];
    
    // Do any additional setup after loading the view.
}

- (void)initNomalUI
{
    UIImageView *imageV = [UIImageView creatImageViewWithSuperView:self.view imageName:@"bindwxSms"];
    [imageV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(40);
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop).inset(30);
        } else {
            make.top.equalTo(self.view.mas_top).inset(94);
        }
    }];
    
    UILabel *label = [UILabel creatLabelWithSuperView:self.view title:@"为保护您的账号安全  请验证手机号" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentLeft];
    label.numberOfLines = 0;
    [label mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(imageV.mas_top).offset(8);
        make.left.equalTo(imageV.mas_right).offset(6);
        make.right.inset(20);
    }];
    NSString *encryptPhone = @"";
    if (self.phone.length > 7) {
        encryptPhone = [self.phone stringByReplacingCharactersInRange:NSMakeRange(3, 4) withString:@"****"];
    }else{
        encryptPhone = self.phone;
    }
    UILabel *phoneLab = [UILabel creatLabelWithSuperView:self.view title:encryptPhone titleFontSize:[UIFont qg_numberFontOfSize:18.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentLeft];
    
    [phoneLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(label);
        make.top.equalTo(label.mas_bottom).offset(6);
    }];
    

    UITextField *vCodeTF = [UITextField creatTextFieldWithSuperView:self.view placeholder:@"请输入验证码" titleFontSize:[UIFont qg_lightFontOfSize:18.0f] textColor:UIColor.textColor3333 tintColor:nil clearButtonMode:UITextFieldViewModeWhileEditing];
    [vCodeTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(40);
        make.top.equalTo(imageV.mas_bottom).offset(36);
        make.height.mas_equalTo(40);
    }];
    vCodeTF.keyboardType = UIKeyboardTypeNumberPad;
    self.vCodeTF = vCodeTF;
    [vCodeTF addTarget:self action:@selector(editChanged:) forControlEvents:UIControlEventEditingChanged];
    
    UIButton *vCodeBtn = [UIButton creatButtonWithSuperView:self.view title:@"获取验证码" titleFont:[UIFont qg_lightFontOfSize:16.0f] textColor:UIColor.textColor3333];
    [vCodeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(vCodeTF.mas_right);
        make.top.height.equalTo(vCodeTF);
        make.right.inset(40);
        make.width.equalTo(vCodeTF.mas_width).multipliedBy(2/3.0);
    }];
    self.vCodeBtn = vCodeBtn;
    
    [vCodeBtn addTarget:self action:@selector(vCodeBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    
    UIView *lineV = [UIView creatViewWithSuperView:self.view backgroundColor:UIColor.lineSeparatorColorDCDC];
    [lineV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(vCodeTF.mas_right);
        make.width.mas_equalTo(0.5);
        make.height.mas_equalTo(30);
        make.top.equalTo(vCodeTF.mas_top).offset(6);
    }];
    
    UIView *lineH = [UIView creatViewWithSuperView:self.view backgroundColor:UIColor.lineSeparatorColorDCDC];
    
    [lineH mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(vCodeTF.mas_bottom).offset(10);
        make.left.equalTo(vCodeTF);
        make.right.equalTo(vCodeBtn);
        make.height.mas_equalTo(0.5);
    }];
    
    self.commitBtn = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.view title:@"绑定" textFont:[UIFont qg_regularFontOfSize:17.0f]];
    [self.commitBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(40);
        make.top.equalTo(lineH.mas_bottom).offset(50);
        make.height.mas_equalTo(40);
    }];
    [self.commitBtn setGradientButtonIsClickEnabled:NO];
    
    [self.commitBtn addTarget:self action:@selector(bindAction:) forControlEvents:UIControlEventTouchUpInside];
    
}

- (void)editChanged:(UITextField *)tf
{
    if (tf.text.length > 6) {
        tf.text = [tf.text substringToIndex:6];
    }
    
    if (tf.text.length != 0) {
        [self.commitBtn setGradientButtonIsClickEnabled:YES];
    }else{
        [self.commitBtn setGradientButtonIsClickEnabled:NO];
    }
}

#pragma mark - 确认绑定

- (void)bindAction:(UIButton *)btn
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    if (!QGUserInfo.sharedUserInfo.isLogin) return;
    if (self.vCodeTF.text.length == 0) return;
    
    [QGHUDManager showHud:nil];
    
    [param setObject:QGUserInfo.sharedUserInfo.userName forKey:@"loginName"];
    [param setObject:self.vCodeTF.text forKey:@"smsCode"];
    [param setObject:self.wxModel.openid forKey:@"openId"];
    [param setObject:self.wxModel.unionid forKey:@"unionId"];
    [param setObject:self.wxModel.headimgurl ? self.wxModel.headimgurl : @"" forKey:@"headImgUrl"];
    [param setObject:self.wxModel.nickname ? self.wxModel.nickname :@"" forKey:@"nickName"];
    [param setObject:self.wxModel.sex forKey:@"sex"];
    [param setObject:@"" forKey:@"userDesc"];
    
   // [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodLoginWechat];
    //@"http://yapi.quantgroups.com/mock/305/vcc/external/login/weChat"
    [networking POST:[QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodLoginWechat] parameters:param success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [QGHUDManager hideHud];
            if (self.bindSuccessBlock) {
                self.bindSuccessBlock(YES);
            }
            [self.navigationController popViewControllerAnimated:YES];
        }else{
            NSString *msg = responseObject[@"msg"]? responseObject[@"msg"]:@"授权失败";
            [QGHUDManager showHud:msg];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:@"网络错误,请稍后再试"];
    }];
}

#pragma mark - 获取验证码

- (void)vCodeBtnAction:(UIButton *)btn
{
    
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    [QGHUDManager showHud:nil];
    // [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodWxVerifyGetCode]
    //@"http://yapi.quantgroups.com/mock/305/vcc/account/send_verify_code"
    [networking POST:[QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodWxVerifyGetCode] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
             [self fireTimer];
        }else{
            NSString *msg = responseObject[@"msg"]? responseObject[@"msg"]:@"授权失败";
            [QGHUDManager showHud:msg];
            [self.countDownTimer destoryTimer];
            self.vCodeBtn.titleLabel.text = @"重新发送";
            [self.vCodeBtn setTitle:@"重新发送" forState:UIControlStateNormal];
            self.vCodeBtn.userInteractionEnabled = YES;
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager hideHud];
        self.vCodeBtn.userInteractionEnabled = YES;
    }];
    
}

//启动定时器
-(void)fireTimer
{
    [self.countDownTimer countDownWithPER_SECBlock:^{
        self.residueTime--;
        if (self.residueTime == 0) {
            [self.countDownTimer destoryTimer];
            self.residueTime = 60;
            self.vCodeBtn.titleLabel.text = @"重新发送";
            [self.vCodeBtn setTitle:@"重新发送" forState:UIControlStateNormal];
            self.vCodeBtn.userInteractionEnabled = YES;
        }else{
            self.vCodeBtn.titleLabel.text = [NSString stringWithFormat:@"重新发送(%lds)",(long)self.residueTime];
            [self.vCodeBtn setTitle:[NSString stringWithFormat:@"重新发送(%lds)",(long)self.residueTime] forState:UIControlStateNormal];
            self.vCodeBtn.userInteractionEnabled = NO;
        }
    }];
}

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [super touchesBegan:touches withEvent:event];
    if ([self.vCodeTF isFirstResponder]) {
        [self.vCodeTF resignFirstResponder];
    }
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
