//
//  QGMineResetPasswordBtnCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/27.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGMineResetPasswordBtnCell.h"
#import "QGBasicUITool.h"

@implementation QGMineResetPasswordBtnCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.submitBtn = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:@"提交" textFont:[UIFont qg_regularFontOfSize:17]];
        [self.submitBtn setGradientButtonIsClickEnabled:NO];
        [self.submitBtn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        self.forgetPassword = [UIButton creatButtonWithSuperView:self.contentView title:@"忘记原登录密码" titleFont:[UIFont qg_regularFontOfSize:16] textColor:[UIColor mainThemeColor]];
        [self.forgetPassword addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        self.forgetPassword.layer.cornerRadius = 20.f;
        
        self.forgetPassword.layer.borderColor = [UIColor mainThemeColor].CGColor;
        self.forgetPassword.layer.borderWidth = 0.5;
        
        [self.submitBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(20);
            make.top.equalTo(self.contentView).inset(46);
            make.height.mas_equalTo(40);
        }];
        
        [self.forgetPassword mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(20);
            make.top.equalTo(self.submitBtn.mas_bottom).offset(20);
            make.height.mas_equalTo(40);
        }];
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
    }
    return self;
}


-(void)btnClick:(UIButton *)btn
{
    
    if (self.cellBlock) {
        if ([btn.titleLabel.text isEqualToString:@"提交"]) {
            self.cellBlock(BottomBtnResetPassword);
        }else if ([btn.titleLabel.text isEqualToString:@"忘记原登录密码"]){
            self.cellBlock(BottomBtnForgetPassword);
        }
    }
    
}


@end
