//
//  QGMineResetLoginPasswordViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/26.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGMineResetLoginPasswordViewController.h"
#import "QGPasswordInputWithTitleCell.h"
#import "QGBasicUITool.h"
#import "QGHeaderTitleTableViewCell.h"
#import "QGMineResetPasswordBtnCell.h"
#import "QGUserCenterRequestApi.h"
@interface QGMineResetLoginPasswordViewController ()
@property (nonatomic, strong)QGMineResetPasswordBtnCell *bottomCell;
///原密码
@property (nonatomic, copy)NSString *oldPassword;
///新密码
@property (nonatomic, copy)NSString *currentPaddword;
///去人密码
@property (nonatomic, copy)NSString *surePassword;





@end

@implementation QGMineResetLoginPasswordViewController

-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"修改登录密码";
    [self custemLeftDefaultBarButtonItem];
    [self setNavBarBottomLineHidden:YES];
    
    //添加隐藏键盘的手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(hideKeyboard)];
    [self.tableView addGestureRecognizer:tap];
}
//隐藏键盘
-(void)hideKeyboard
{
    [self.view endEditing:YES];
}

///修改按钮的可点击状态
-(void)changeStatus
{
    if (![NSString isEmpty:self.oldPassword] && ![NSString isEmpty:self.currentPaddword] && ![NSString isEmpty:self.surePassword]) {
        [self.bottomCell.submitBtn setGradientButtonIsClickEnabled:YES];
    }else{
        [self.bottomCell.submitBtn setGradientButtonIsClickEnabled:NO];
    }
    
}

///提交修改密码
-(void)submitPassword
{
    
    if (![self.currentPaddword isEqualToString:self.surePassword]) {
        [QGHUDManager showHud:@"两次密码输入不一致"];
        return;
    }
    
    if (!self.currentPaddword.isValidPasswordString) {
        [QGHUDManager showHud:@"密码不合法!8-20位字母数字组合"];
        return;
    }
    
    if ([self.oldPassword isEqualToString:self.currentPaddword]) {
        [QGHUDManager showHud:@"新旧密码一致,无需修改"];
        return;
    }
    
    NSString *url = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodResetPaddword];
    
    NSMutableDictionary *parame = [[NSMutableDictionary alloc] initWithCapacity:2];
    [parame setObject:[QGUserInfo sharedUserInfo].userName forKey:@"phoneNo"];
    [parame setObject:self.oldPassword forKey:@"password"];
    [parame setObject:self.surePassword forKey:@"passwordNew"];
    [QGHUDManager showHud:nil];
    
    [[QGTalosNetwork shareManager] POST:url parameters:parame success:^(id  _Nonnull responseObject) {
        //业务请求成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [QGHUDManager showHud:@"修改成功"];
            
            [QGUserInfo logOut];
            
            [self.navigationController popViewControllerAnimated:NO];
            self.callBackBlock(nil, nil);
            //埋点
            NSMutableDictionary *info = [[NSMutableDictionary alloc] init];
            [info setObject:@"个人中心" forKey:@"abse_page_name"];
            [info setObject:@"修改登录密码" forKey:@"abse_action_name"];
            [info setObject:@"success" forKey:@"abse_state_value"];
            [QGAnalyticsService analyticsTrack:@"AppBusinessStateEvent" withProperties: info];
        }
        //业务请求失败
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
         [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}


-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 2;
    }else{
        return 4;
    }
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    __weak typeof(self)weakSelf = self;
    if (indexPath.section == 0) {
        if (indexPath.row == 0) {
            QGHeaderTitleTableViewCell *cell = (QGHeaderTitleTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGHeaderTitleTableViewCell class]) dequeueTableView:tableView];
            cell.titleLabel.text = @"请输入原登录密码";
            return cell;
        }else{
            
            
            QGPasswordInputWithTitleCell *cell = [tableView dequeueReusableCellWithIdentifier:@"old"];
            
            if (!cell) {
               cell = [[QGPasswordInputWithTitleCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"old" cellTitle:@"原密码"];
            }
            
            cell.hideUnderLine = YES;
            cell.cellBlock = ^(NSString *password) {
                weakSelf.oldPassword = password;
                
                [weakSelf changeStatus];
            };
            
            return cell;
        }
        
    }else{
        if (indexPath.row == 0) {
            QGHeaderTitleTableViewCell *cell = (QGHeaderTitleTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGHeaderTitleTableViewCell class]) dequeueTableView:tableView];
            cell.titleLabel.text = @"请设置新登录密码";

            return cell;
            
        }else if (indexPath.row == 1){
            QGPasswordInputWithTitleCell *cell = [tableView dequeueReusableCellWithIdentifier:@"new"];
            
            if (!cell) {
                cell = [[QGPasswordInputWithTitleCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"new" cellTitle:@"新登录密码"];
            }
            cell.hideUnderLine = NO;

            cell.cellBlock = ^(NSString *password) {
                weakSelf.currentPaddword = password;
                [weakSelf changeStatus];

            };
            
            return cell;
        }else if (indexPath.row == 2){
            QGPasswordInputWithTitleCell *cell = [tableView dequeueReusableCellWithIdentifier:@"again"];
            
            if (!cell) {
                cell = [[QGPasswordInputWithTitleCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"again" cellTitle:@"再输一次"];
            }
            cell.hideUnderLine = NO;

            cell.cellBlock = ^(NSString *password) {
                weakSelf.surePassword = password;
                [weakSelf changeStatus];

            };
            
            return cell;
        } else{

            QGMineResetPasswordBtnCell *cell = (QGMineResetPasswordBtnCell *)[self getCellFromClassName:NSStringFromClass([QGMineResetPasswordBtnCell class]) dequeueTableView:tableView];
            self.bottomCell = cell;
            
            cell.cellBlock = ^(BottomBtnType btnType) {
              
                if (btnType == BottomBtnForgetPassword) {//忘记密码
                    
                    //忘记密码埋点
                    NSMutableDictionary *info = [[NSMutableDictionary alloc] init];
                    [info setObject:@"个人中心" forKey:@"abse_page_name"];
                    [info setObject:@"忘记原登录密码" forKey:@"abse_action_name"];
                    [QGAnalyticsService analyticsTrack:@"AppCoreModelClick" withProperties: info];
                    
                    //忘记密码页面跳转
                    [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGRetriecePasswordViewController] isPush:NO parameters:@{@"phoneNumberStr":[QGUserInfo sharedUserInfo].userName} handlerBlock:^(NSString *tag, NSDictionary *parameters) {
                        if ([tag isEqualToString:LoginTag_QGMainLoginViewController_resetPassword]) {
                            NSLog(@"修改密码成功哈哈哈哈");
                            [QGUserInfo logOut];

                            [self.navigationController popViewControllerAnimated:NO];
                            self.callBackBlock(nil, nil);
                            
                        }
                    }];
                    
                }else if (btnType == BottomBtnResetPassword){//修改密码提交
                    
                    [weakSelf submitPassword];
                }
                
            };
            

            return cell;
        }
    }
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    if (indexPath.section == 0) {
        if (indexPath.row == 0) {
            return 65;
        }else{
            return 81;
        }
        
    }else{
        if (indexPath.row == 0) {
            return 65;
        }else if (indexPath.row == 1 || indexPath.row == 2){
            return 81;
        }else{
            return 146.5;
        }
    }
    
}

-(CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0.01;
}
-(CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    if (section == 0) {
        return 10;
    }else{
        return 0.01;
    }
}
-(UIView *)tableView:(UITableView *)tableView viewForFooterInSection:(NSInteger)section
{
    if (section ==0) {
        UIView *view = [UIView creatViewWithSuperView:nil backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        
        return view;
    }else{        
        return [UIView new];
    }
}

@end
