//
//  QGUserCenterHeaderCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/12/12.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGUserCenterHeaderCell.h"
#import "QGBasicUITool.h"
#import "QGGradientShadowButton.h"
#import "UIImageView+QGWebCache.h"
@interface QGUserCenterHeaderCell ()

///用户名或者手机号
@property (nonatomic, strong)UILabel *userNameLabel;

///描述文字
@property (nonatomic, strong)UILabel *subpropmtLabel;

///头像
@property (nonatomic, strong)UIImageView *iconImageView;

///登录按钮
@property (nonatomic, strong, readwrite)UIButton *longinBtn;
@end


@implementation QGUserCenterHeaderCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {

        //用户姓名或手机号
        self.userNameLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:20*Screen_Scaling] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.userNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.leftMargin.mas_equalTo(20);
            make.rightMargin.mas_equalTo(125);
            make.topMargin.mas_equalTo(2);
            make.height.mas_equalTo(28);
        }];
        
       //享花卡不同状态的描述
        self.subpropmtLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"随心享花卡，赚钱等你拿" titleFontSize:[UIFont qg_lightFontOfSize:14*Screen_Scaling] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.subpropmtLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.leftMargin.mas_equalTo(20);
            make.right.equalTo(self.contentView).offset(-30-60*Screen_Scaling);
            make.top.equalTo(self.userNameLabel.mas_bottom).offset(9);
            make.height.mas_equalTo(20);
        }];
        
        //用户头像
        self.iconImageView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:@"headsculpture_image_60"];
        self.iconImageView.layer.cornerRadius = 30*Screen_Scaling;
        self.iconImageView.clipsToBounds = YES;
        self.iconImageView.contentMode = UIViewContentModeScaleAspectFill;
        self.iconImageView.hidden = YES;
        [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.topMargin.mas_equalTo(2);
            make.right.equalTo(self.contentView).offset(-30);
            make.width.height.mas_equalTo(60*Screen_Scaling);
        }];
        
        //登陆按钮
        self.longinBtn = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:@"去登录" textFont:[UIFont qg_regularFontOfSize:14]];
        [self.longinBtn mas_makeConstraints:^(MASConstraintMaker *make) {
           make.rightMargin.mas_equalTo(-20);
           make.topMargin.mas_equalTo(10);
           make.width.mas_equalTo(95);
           make.height.mas_equalTo(33);
        }];

        self.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    return self;
}


- (void)setUserCenterModel:(QGUserCenterDataModel *)userCenterModel
{
    if (_userCenterModel != userCenterModel) {
        _userCenterModel = userCenterModel;
        
        QGUserInfo *userInfo = [QGUserInfo sharedUserInfo];
        if (userInfo.isLogin) {//用户已经登录
            self.longinBtn.hidden = YES;
            self.iconImageView.hidden = NO;
            self.userNameLabel.text = userInfo.realName;
            [self.iconImageView setImageWithPlaceholder:@"headsculpture_image_60" URLString:userInfo.avatar];
        }else{
            self.userNameLabel.text = @"Hi,你好";
            self.longinBtn.hidden = NO;
            self.iconImageView.hidden = YES;
        }
        
        
    }
}



- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
